/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.Random;
import junit.framework.TestCase;

public class MulticoreWrapperTest
extends TestCase {
    private MulticoreWrapper<Integer, Integer> wrapper;
    private int nThreads;

    public void setUp() {
        this.nThreads = -1;
    }

    public void testSynchronization() {
        this.wrapper = new MulticoreWrapper<Integer, Integer>(this.nThreads, new DelayedIdentityFunction());
        int lastReturned = 0;
        int nItems = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wrapper.put(i);
            while (this.wrapper.peek()) {
                int result = this.wrapper.poll();
                System.err.printf("Result: %d%n", result);
                MulticoreWrapperTest.assertEquals((int)result, (int)lastReturned++);
            }
        }
        this.wrapper.join();
        while (this.wrapper.peek()) {
            int result = this.wrapper.poll();
            System.err.printf("Result2: %d%n", result);
            MulticoreWrapperTest.assertEquals((int)result, (int)lastReturned++);
        }
    }

    public void testUnsynchronized() {
        this.wrapper = new MulticoreWrapper<Integer, Integer>(this.nThreads, new DelayedIdentityFunction(), false);
        int nReturned = 0;
        int nItems = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wrapper.put(i);
            while (this.wrapper.peek()) {
                int result = this.wrapper.poll();
                System.err.printf("Result: %d%n", result);
                ++nReturned;
            }
        }
        this.wrapper.join();
        while (this.wrapper.peek()) {
            int result = this.wrapper.poll();
            System.err.printf("Result2: %d%n", result);
            ++nReturned;
        }
        MulticoreWrapperTest.assertEquals((int)1000, (int)nReturned);
    }

    private static class DelayedIdentityFunction
    implements ThreadsafeProcessor<Integer, Integer> {
        private final Random random = new Random();
        private static final int MAX_SLEEP_TIME = 3;

        private DelayedIdentityFunction() {
        }

        @Override
        public Integer process(Integer input) {
            int sleepTime = this.nextSleepTime();
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return input;
        }

        private synchronized int nextSleepTime() {
            return this.random.nextInt(3);
        }

        @Override
        public ThreadsafeProcessor<Integer, Integer> newInstance() {
            return this;
        }
    }
}

