/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.wordseg.ChineseStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.TestCase;

public class ChineseStringUtilsTest
extends TestCase {
    private static final Integer SEGMENT_ATTEMPTS_PER_THREAD = 100;
    private static final Integer THREADS = 8;

    public void testMultithreadedCombineSegmentedSentence() throws Exception {
        SeqClassifierFlags flags = ChineseStringUtilsTest.createTestFlags();
        List<CoreLabel> labels = ChineseStringUtilsTest.createTestTokens();
        ArrayList<Future<Boolean>> tasks = new ArrayList<Future<Boolean>>(THREADS);
        ExecutorService executor = Executors.newFixedThreadPool(THREADS);
        for (int v = 0; v < THREADS; ++v) {
            Future<Boolean> future = executor.submit(() -> {
                for (int i = 0; i < SEGMENT_ATTEMPTS_PER_THREAD; ++i) {
                    ChineseStringUtils.combineSegmentedSentence(labels, flags);
                }
                return true;
            });
            tasks.add(future);
        }
        for (Future future : tasks) {
            assert (((Boolean)future.get()).booleanValue());
        }
    }

    private static List<CoreLabel> createTestTokens() {
        CoreLabel token = new CoreLabel();
        token.setWord("\u4f60\u597d\uff0c\u4e16\u754c");
        token.setValue("\u4f60\u597d\uff0c\u4e16\u754c");
        token.set(CoreAnnotations.ChineseSegAnnotation.class, "1");
        token.set(CoreAnnotations.AnswerAnnotation.class, "0");
        ArrayList<CoreLabel> labels = new ArrayList<CoreLabel>();
        labels.add(token);
        return labels;
    }

    private static SeqClassifierFlags createTestFlags() {
        SeqClassifierFlags flags = new SeqClassifierFlags();
        flags.sighanPostProcessing = true;
        flags.usePk = true;
        flags.keepEnglishWhitespaces = false;
        flags.keepAllWhitespaces = false;
        return flags;
    }
}

