#pragma once
#include <stdint.h>
static inline uint32_t logical_op3(uint32_t a, uint32_t b, uint32_t c, uint8_t immLut) {
    switch(immLut) {
        case 0x00: return 0x0;
        case 0x01: return (~a & ~b & ~c);
        case 0x02: return (c & ~a & ~b);
        case 0x03: return (~a & ~b);
        case 0x04: return (b & ~a & ~c);
        case 0x05: return (~a & ~c);
        case 0x06: return ((b ^ c) & ~a);
        case 0x07: return ((b ^ c) & ~a) | (~a & ~c);
        case 0x08: return (b & c & ~a);
        case 0x09: return (~(b ^ c) & ~a);
        case 0x0a: return (c & ~a);
        case 0x0b: return (c & ~a) | (~a & ~b);
        case 0x0c: return (b & ~a);
        case 0x0d: return (b & ~a) | (~a & ~c);
        case 0x0e: return (b & ~a) | (c & ~a);
        case 0x0f: return (~a);
        case 0x10: return (a & ~b & ~c);
        case 0x11: return (~b & ~c);
        case 0x12: return ((a ^ c) & ~b);
        case 0x13: return ((a ^ c) & ~b) | (~a & ~b);
        case 0x14: return ((a ^ b) & ~c);
        case 0x15: return ((a ^ b) & ~c) | (~a & ~c);
        case 0x16: return ((a ^ b) & ~c) | ((b ^ c) & ~a);
        case 0x17: return ((b ^ c) & ~a) | (~b & ~c);
        case 0x18: return (a & ~b & ~c) | (b & c & ~a);
        case 0x19: return (~(b ^ c) & ~a) | (~b & ~c);
        case 0x1a: return ((a ^ c) & ~b) | (c & ~a);
        case 0x1b: return ((a ^ c) & ~b) | (c & ~a) | (~a & ~b);
        case 0x1c: return ((a ^ b) & ~c) | (b & ~a);
        case 0x1d: return ((a ^ b) & ~c) | (b & ~a) | (~a & ~c);
        case 0x1e: return ((a ^ b) & ~c) | (c & ~a);
        case 0x1f: return ((a ^ b) & ~c) | (~a);
        case 0x20: return (a & c & ~b);
        case 0x21: return (~(a ^ c) & ~b);
        case 0x22: return (c & ~b);
        case 0x23: return (c & ~b) | (~a & ~b);
        case 0x24: return (a & c & ~b) | (b & ~a & ~c);
        case 0x25: return (~(a ^ c) & ~b) | (~a & ~c);
        case 0x26: return ((b ^ c) & ~a) | (c & ~b);
        case 0x27: return (c & ~b) | (~a & ~c);
        case 0x28: return ((a ^ b) & c);
        case 0x29: return ((a ^ b) & c) | (~(b ^ c) & ~a);
        case 0x2a: return ((a ^ b) & c) | (c & ~b);
        case 0x2b: return ((a ^ b) & c) | (~a & ~b);
        case 0x2c: return ((a ^ b) & c) | (b & ~a);
        case 0x2d: return ((a ^ b) & c) | (~a & ~c);
        case 0x2e: return (b & ~a) | (c & ~b);
        case 0x2f: return (c & ~b) | (~a);
        case 0x30: return (a & ~b);
        case 0x31: return (a & ~b) | (~b & ~c);
        case 0x32: return (a & ~b) | (c & ~b);
        case 0x33: return (~b);
        case 0x34: return ((a ^ b) & ~c) | (a & ~b);
        case 0x35: return (a & ~b) | (~a & ~c);
        case 0x36: return ((a ^ b) & ~c) | (c & ~b);
        case 0x37: return ((a ^ b) & ~c) | (~b);
        case 0x38: return ((a ^ b) & c) | (a & ~b);
        case 0x39: return ((a ^ b) & c) | (~b & ~c);
        case 0x3a: return ((a ^ b) & c) | (a & ~b) | (c & ~b);
        case 0x3b: return ((a ^ b) & c) | (~b);
        case 0x3c: return ((a ^ b));
        case 0x3d: return ((a ^ b)) | (~a & ~c);
        case 0x3e: return ((a ^ b)) | (c & ~b);
        case 0x3f: return (~a) | (~b);
        case 0x40: return (a & b & ~c);
        case 0x41: return (~(a ^ b) & ~c);
        case 0x42: return (a & b & ~c) | (c & ~a & ~b);
        case 0x43: return (~(a ^ b) & ~c) | (~a & ~b);
        case 0x44: return (b & ~c);
        case 0x45: return (b & ~c) | (~a & ~c);
        case 0x46: return ((b ^ c) & ~a) | (b & ~c);
        case 0x47: return ((b ^ c) & ~a) | (b & ~c) | (~a & ~c);
        case 0x48: return ((a ^ c) & b);
        case 0x49: return ((a ^ c) & b) | (~(a ^ b) & ~c);
        case 0x4a: return ((a ^ c) & b) | (c & ~a);
        case 0x4b: return ((a ^ c) & b) | (~a & ~b);
        case 0x4c: return (b & ~a) | (b & ~c);
        case 0x4d: return (b & ~a) | (b & ~c) | (~a & ~c);
        case 0x4e: return (b & ~c) | (c & ~a);
        case 0x4f: return (b & ~c) | (~a);
        case 0x50: return (a & ~c);
        case 0x51: return (a & ~c) | (~b & ~c);
        case 0x52: return ((a ^ c) & ~b) | (a & ~c);
        case 0x53: return (a & ~c) | (~a & ~b);
        case 0x54: return (a & ~c) | (b & ~c);
        case 0x55: return (~c);
        case 0x56: return ((b ^ c) & ~a) | (a & ~c);
        case 0x57: return ((b ^ c) & ~a) | (~c);
        case 0x58: return ((a ^ c) & b) | (a & ~c);
        case 0x59: return ((a ^ c) & b) | (~b & ~c);
        case 0x5a: return ((a ^ c));
        case 0x5b: return ((a ^ c)) | (~a & ~b);
        case 0x5c: return (a & ~c) | (b & ~a);
        case 0x5d: return (b & ~a) | (~c);
        case 0x5e: return ((a ^ c)) | (b & ~a);
        case 0x5f: return ((a ^ c)) | (~a);
        case 0x60: return ((b ^ c) & a);
        case 0x61: return ((b ^ c) & a) | (~(a ^ b) & ~c);
        case 0x62: return ((b ^ c) & a) | (c & ~b);
        case 0x63: return ((b ^ c) & a) | (~a & ~b);
        case 0x64: return ((b ^ c) & a) | (b & ~c);
        case 0x65: return ((b ^ c) & a) | (~a & ~c);
        case 0x66: return ((b ^ c));
        case 0x67: return ((b ^ c)) | (~a & ~c);
        case 0x68: return ((a ^ b) & c) | ((b ^ c) & a);
        case 0x69: return (~(a ^ b ^ c));
        case 0x6a: return ((b ^ c) & a) | (c & ~a);
        case 0x6b: return (c & ~b) | (~(a ^ b ^ c));
        case 0x6c: return ((a ^ c) & b) | ((b ^ c) & a) | (b & ~c);
        case 0x6d: return (b & ~c) | (~(a ^ b ^ c));
        case 0x6e: return ((b ^ c)) | (c & ~a);
        case 0x6f: return ((b ^ c)) | (~a);
        case 0x70: return ((b ^ c) & a) | (a & ~b);
        case 0x71: return ((b ^ c) & a) | (~b & ~c);
        case 0x72: return ((b ^ c) & a) | (a & ~b) | (c & ~b);
        case 0x73: return ((b ^ c) & a) | (~b);
        case 0x74: return (a & ~b) | (b & ~c);
        case 0x75: return ((b ^ c) & a) | (~c);
        case 0x76: return ((b ^ c)) | (a & ~b);
        case 0x77: return (~b) | (~c);
        case 0x78: return ((a ^ c) & b) | (a & ~b);
        case 0x79: return (a & ~b) | (~(a ^ b ^ c));
        case 0x7a: return ((a ^ c)) | (c & ~b);
        case 0x7b: return ((a ^ c)) | (~b);
        case 0x7c: return ((a ^ b)) | (a & ~c);
        case 0x7d: return ((a ^ b)) | (~c);
        case 0x7e: return ((a ^ b)) | ((a ^ c));
        case 0x7f: return ((b ^ c)) | (~a) | (~c);
        case 0x80: return (a & b & c);
        case 0x81: return (a & b & c) | (~a & ~b & ~c);
        case 0x82: return (c & ~(a ^ b));
        case 0x83: return (c & ~(a ^ b)) | (~a & ~b);
        case 0x84: return (b & ~(a ^ c));
        case 0x85: return (b & ~(a ^ c)) | (~a & ~c);
        case 0x86: return ((b ^ c) & ~a) | (c & ~(a ^ b));
        case 0x87: return (c & ~(a ^ b)) | (~a & ~c);
        case 0x88: return (b & c);
        case 0x89: return (b & c) | (~(b ^ c) & ~a);
        case 0x8a: return (b & c) | (c & ~a);
        case 0x8b: return (b & c) | (~a & ~b);
        case 0x8c: return (b & c) | (b & ~a);
        case 0x8d: return (b & c) | (~a & ~c);
        case 0x8e: return (b & c) | (b & ~a) | (c & ~a);
        case 0x8f: return (b & c) | (~a);
        case 0x90: return (a & ~(b ^ c));
        case 0x91: return (a & ~(b ^ c)) | (~b & ~c);
        case 0x92: return ((a ^ c) & ~b) | (c & ~(a ^ b));
        case 0x93: return ((a ^ c) & ~b) | (c & ~(a ^ b)) | (~a & ~b);
        case 0x94: return ((a ^ b) & ~c) | (a & ~(b ^ c));
        case 0x95: return (a & ~(b ^ c)) | (~a & ~c);
        case 0x96: return ((a ^ b ^ c));
        case 0x97: return ((a ^ b ^ c)) | (~a & ~c);
        case 0x98: return (a & ~(b ^ c)) | (b & c);
        case 0x99: return (~(b ^ c));
        case 0x9a: return ((a ^ c) & ~b) | (b & c);
        case 0x9b: return (c & ~a) | (~(b ^ c));
        case 0x9c: return ((a ^ b) & ~c) | (b & c);
        case 0x9d: return (b & ~a) | (~(b ^ c));
        case 0x9e: return ((a ^ b ^ c)) | (b & c);
        case 0x9f: return (~(b ^ c)) | (~a);
        case 0xa0: return (a & c);
        case 0xa1: return (a & c) | (~(a ^ c) & ~b);
        case 0xa2: return (a & c) | (c & ~b);
        case 0xa3: return (a & c) | (~a & ~b);
        case 0xa4: return (a & c) | (b & ~(a ^ c));
        case 0xa5: return (~(a ^ c));
        case 0xa6: return ((b ^ c) & ~a) | (a & c);
        case 0xa7: return (c & ~b) | (~(a ^ c));
        case 0xa8: return (a & c) | (b & c);
        case 0xa9: return (a & c) | (~(b ^ c) & ~a);
        case 0xaa: return (c);
        case 0xab: return (c) | (~a & ~b);
        case 0xac: return (a & c) | (b & ~a);
        case 0xad: return (b & c) | (~(a ^ c));
        case 0xae: return (b & ~a) | (c);
        case 0xaf: return (c) | (~a);
        case 0xb0: return (a & c) | (a & ~b);
        case 0xb1: return (a & c) | (~b & ~c);
        case 0xb2: return (a & c) | (a & ~b) | (c & ~b);
        case 0xb3: return (a & c) | (~b);
        case 0xb4: return ((a ^ b) & ~c) | (a & c);
        case 0xb5: return (a & ~b) | (~(a ^ c));
        case 0xb6: return ((a ^ b ^ c)) | (a & c);
        case 0xb7: return (~(a ^ c)) | (~b);
        case 0xb8: return (a & ~b) | (b & c);
        case 0xb9: return (a & c) | (~(b ^ c));
        case 0xba: return (a & ~b) | (c);
        case 0xbb: return (c) | (~b);
        case 0xbc: return ((a ^ b)) | (b & c);
        case 0xbd: return ((a ^ b)) | (~(a ^ c));
        case 0xbe: return ((a ^ b)) | (c);
        case 0xbf: return (c) | (~a) | (~b);
        case 0xc0: return (a & b);
        case 0xc1: return (a & b) | (~(a ^ b) & ~c);
        case 0xc2: return (a & b) | (c & ~(a ^ b));
        case 0xc3: return (~(a ^ b));
        case 0xc4: return (a & b) | (b & ~c);
        case 0xc5: return (a & b) | (~a & ~c);
        case 0xc6: return ((b ^ c) & ~a) | (a & b);
        case 0xc7: return (b & ~c) | (~(a ^ b));
        case 0xc8: return (a & b) | (b & c);
        case 0xc9: return (b & c) | (~(a ^ b) & ~c);
        case 0xca: return (a & b) | (c & ~a);
        case 0xcb: return (b & c) | (~(a ^ b));
        case 0xcc: return (b);
        case 0xcd: return (b) | (~a & ~c);
        case 0xce: return (b) | (c & ~a);
        case 0xcf: return (b) | (~a);
        case 0xd0: return (a & b) | (a & ~c);
        case 0xd1: return (a & b) | (~b & ~c);
        case 0xd2: return ((a ^ c) & ~b) | (a & b);
        case 0xd3: return (a & ~c) | (~(a ^ b));
        case 0xd4: return (a & b) | (a & ~c) | (b & ~c);
        case 0xd5: return (a & b) | (~c);
        case 0xd6: return ((a ^ b ^ c)) | (a & b);
        case 0xd7: return ((a ^ b ^ c)) | (~c);
        case 0xd8: return (a & ~c) | (b & c);
        case 0xd9: return (a & b) | (~(b ^ c));
        case 0xda: return ((a ^ c)) | (b & c);
        case 0xdb: return ((a ^ c)) | (~(b ^ c));
        case 0xdc: return (a & ~c) | (b);
        case 0xdd: return (b) | (~c);
        case 0xde: return ((a ^ c)) | (b);
        case 0xdf: return ((a ^ c)) | (b) | (~a);
        case 0xe0: return (a & b) | (a & c);
        case 0xe1: return (a & c) | (~(a ^ b) & ~c);
        case 0xe2: return (a & b) | (c & ~b);
        case 0xe3: return (a & c) | (~(a ^ b));
        case 0xe4: return (a & c) | (b & ~c);
        case 0xe5: return (a & b) | (~(a ^ c));
        case 0xe6: return ((b ^ c)) | (a & b);
        case 0xe7: return ((b ^ c)) | (~(a ^ c));
        case 0xe8: return (a & b) | (a & c) | (b & c);
        case 0xe9: return (b & c) | (~(a ^ b ^ c));
        case 0xea: return (a & b) | (c);
        case 0xeb: return (c) | (~(a ^ b));
        case 0xec: return (a & c) | (b);
        case 0xed: return (b) | (~(a ^ c));
        case 0xee: return (b) | (c);
        case 0xef: return (b) | (c) | (~a);
        case 0xf0: return (a);
        case 0xf1: return (a) | (~b & ~c);
        case 0xf2: return (a) | (c & ~b);
        case 0xf3: return (a) | (~b);
        case 0xf4: return (a) | (b & ~c);
        case 0xf5: return (a) | (~c);
        case 0xf6: return ((b ^ c)) | (a);
        case 0xf7: return (a) | (~b) | (~c);
        case 0xf8: return (a) | (b & c);
        case 0xf9: return (a) | (~(b ^ c));
        case 0xfa: return (a) | (c);
        case 0xfb: return (a) | (c) | (~b);
        case 0xfc: return (a) | (b);
        case 0xfd: return (a) | (b) | (~c);
        case 0xfe: return (a) | (b) | (c);
        case 0xff: return 0xffffffff;
    }
}
