#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include "ptxc.h"
#include "lop3_lut.h"
#include "readbyte_prmt.h"
#include "ptxc_utils.h"
float execute_abs_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = fabsf(src1);
	dst = tmp_dst;
	return dst;
}


void execute_ret () {
        

        return;
}


double execute_abs_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = fabs(src1);
	dst = tmp_dst;
	return dst;
}


float execute_abs_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = fabsf(src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_abs_s16 (int16_t src1) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = abs(src1);
	dst = tmp_dst;
	return dst;
}


int32_t execute_abs_s32 (int32_t src1) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = abs(src1);
	dst = tmp_dst;
	return dst;
}


int64_t execute_abs_s64 (int64_t src1) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = labs(src1);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_add_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg) {
        struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_addc_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg) {
        struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_addc_u32 (uint32_t src1, uint32_t src2, struct cc_register cc_reg) {
        struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_addc_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg) {
        struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_addc_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg) {
        struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_addc_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg) {
        struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_add_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg) {
        struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_add_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg) {
        struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


float execute_add_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


double execute_add_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


float execute_add_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = (src1 + src2);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE((src1 + src2));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rm_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


double execute_add_rm_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_add_rm_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = ADD_ROUND(src1, src2, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rm_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_DOWNWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rm_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_DOWNWARD));
	dst = tmp_dst;
	return dst;
}


float execute_add_rn_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_add_rn_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_add_rn_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = ADD_ROUND(src1, src2, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rn_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_TONEAREST));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rn_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_TONEAREST));
	dst = tmp_dst;
	return dst;
}


float execute_add_rp_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_add_rp_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_add_rp_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = ADD_ROUND(src1, src2, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rp_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_UPWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rp_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_UPWARD));
	dst = tmp_dst;
	return dst;
}


float execute_add_rz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_add_rz_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = ADD_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_add_rz_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = ADD_ROUND(src1, src2, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rz_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_TOWARDZERO));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_add_rz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(ADD_ROUND(src1, src2, FE_TOWARDZERO));
	dst = tmp_dst;
	return dst;
}


int16_t execute_add_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_add_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


float execute_add_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE((src1 + src2));
	dst = tmp_dst;
	return dst;
}


int32_t execute_add_sat_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = ADD_SATURATE_s32(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_add_u16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_add_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_and_b16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = (src1 & src2);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_and_pred (unsigned int src1, unsigned int src2) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (src1 & src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_and_b32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = (src1 & src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_and_b64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = (src1 & src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_s32 (int32_t src2) {
        int32_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	if ((tmp_src & (1 << 31))) {
		tmp_src = ~(tmp_src);
	};
	tmp_dst = 4294967295U;
	i = 31;
	while((i >= 0)) {
		if ((tmp_src & (1 << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_s64 (int64_t src2) {
        int64_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	if ((tmp_src & (1L << 63L))) {
		tmp_src = ~(tmp_src);
	};
	tmp_dst = 4294967295U;
	i = 63;
	while((i >= 0)) {
		if ((tmp_src & (1L << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_shiftamt_s32 (int32_t src2) {
        int32_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	if ((tmp_src & (1 << 31))) {
		tmp_src = ~(tmp_src);
	};
	tmp_dst = 4294967295U;
	i = 31;
	while((i >= 0)) {
		if ((tmp_src & (1 << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	if ((tmp_dst != 4294967295U)) {
		tmp_dst = (31U - tmp_dst);
	};
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_shiftamt_s64 (int64_t src2) {
        int64_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	if ((tmp_src & (1L << 63L))) {
		tmp_src = ~(tmp_src);
	};
	tmp_dst = 4294967295U;
	i = 63;
	while((i >= 0)) {
		if ((tmp_src & (1L << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	if ((tmp_dst != 4294967295U)) {
		tmp_dst = (63U - tmp_dst);
	};
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_shiftamt_u32 (uint32_t src2) {
        uint32_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	tmp_dst = 4294967295U;
	i = 31;
	while((i >= 0)) {
		if ((tmp_src & (1U << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	if ((tmp_dst != 4294967295U)) {
		tmp_dst = (31U - tmp_dst);
	};
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_shiftamt_u64 (uint64_t src2) {
        uint64_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	tmp_dst = 4294967295U;
	i = 63;
	while((i >= 0)) {
		if ((tmp_src & (1UL << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	if ((tmp_dst != 4294967295U)) {
		tmp_dst = (63U - tmp_dst);
	};
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_u32 (uint32_t src2) {
        uint32_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	tmp_dst = 4294967295U;
	i = 31;
	while((i >= 0)) {
		if ((tmp_src & (1U << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_bfind_u64 (uint64_t src2) {
        uint64_t tmp_src;
	uint32_t tmp_dst;
	int32_t i;
	uint32_t dst;

        ;;
	tmp_src = src2;
	tmp_dst = 4294967295U;
	i = 63;
	while((i >= 0)) {
		if ((tmp_src & (1UL << i))) {
		tmp_dst = ((uint32_t) i);
		break
;
	};
		i = (i - 1);
};
	;;
	tmp_dst = tmp_dst;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_clz_b32 (uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t tmp_src;
	uint32_t dst;

        tmp_dst = 0U;
	;;
	tmp_src = src2;
	while(((tmp_dst < 32U) && ((tmp_src & 2147483648U) == 0U))) {
		tmp_dst = (tmp_dst + 1U);
		tmp_src = SHL(tmp_src, 1U);
};
	dst = tmp_dst;
	return dst;
}


uint16_t execute_cnot_b16 (uint16_t src1) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = ((src1 == 0) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_cnot_b32 (uint32_t src1) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = ((src1 == 0U) ? 1U : 0U);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_cnot_b64 (uint64_t src1) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = ((src1 == 0UL) ? 1UL : 0UL);
	dst = tmp_dst;
	return dst;
}


float execute_copysign_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = COPYSIGN(src2, src1);
	dst = tmp_dst;
	return dst;
}


double execute_copysign_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = COPYSIGN(src2, src1);
	dst = tmp_dst;
	return dst;
}


float execute_cos_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = COSINE(src1);
	dst = tmp_dst;
	return dst;
}


float execute_div_approx_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_APPROX(src1, src2);
	dst = tmp_dst;
	return dst;
}


float execute_div_approx_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_APPROX(src1, src2);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_div_full_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_FULL(src1, src2);
	dst = tmp_dst;
	return dst;
}


float execute_div_full_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_FULL(src1, src2);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


double execute_div_rm_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_div_rm_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_ROUND(src1, src2, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_div_rn_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_div_rn_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_div_rn_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_ROUND(src1, src2, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_div_rp_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_div_rp_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_div_rp_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_ROUND(src1, src2, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_div_rz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_div_rz_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_div_rz_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = DIV_ROUND(src1, src2, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_div_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        if ((src2 == 0)) {
		tmp_dst = ~((uint16_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


int32_t execute_div_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        if ((src2 == 0)) {
		tmp_dst = ~((uint32_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


int64_t execute_div_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        if ((src2 == 0L)) {
		tmp_dst = ~((uint64_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


uint16_t execute_div_u16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        if ((src2 == 0)) {
		tmp_dst = ~((uint16_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_div_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        if ((src2 == 0U)) {
		tmp_dst = ~((uint32_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_div_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        if ((src2 == 0UL)) {
		tmp_dst = ~((uint64_t) 0);
	} else {
		tmp_dst = (src1 / src2);
	};
	dst = tmp_dst;
	return dst;
}


int32_t execute_dp4a_s32_s32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t tmp_dst_2;
	uint32_t num1[4];
	uint32_t num2[4];
	int32_t i;
	int32_t tmp_dst;
	int32_t dst;

        tmp_dst_2 = src3;
	;;
	extractAndSignExt_4(src1, num1);
	;;
	extractAndSignExt_4(src2, num2);
	for(i = 0; i < 4; i++) {
		tmp_dst_2 = (tmp_dst_2 + (num1[i] * num2[i]));
};
	tmp_dst = ((int32_t) tmp_dst_2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_dp4a_s32_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t tmp_dst_2;
	uint32_t num1[4];
	uint32_t num2[4];
	int32_t i;
	int32_t tmp_dst;
	int32_t dst;

        tmp_dst_2 = src3;
	;;
	extractAndSignExt_4(src1, num1);
	;;
	extractAndZeroExt_4(src2, num2);
	for(i = 0; i < 4; i++) {
		tmp_dst_2 = (tmp_dst_2 + (num1[i] * num2[i]));
};
	tmp_dst = ((int32_t) tmp_dst_2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_dp4a_u32_s32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t tmp_dst_2;
	uint32_t num1[4];
	uint32_t num2[4];
	int32_t i;
	int32_t tmp_dst;
	int32_t dst;

        tmp_dst_2 = src3;
	;;
	extractAndZeroExt_4(src1, num1);
	;;
	extractAndSignExt_4(src2, num2);
	for(i = 0; i < 4; i++) {
		tmp_dst_2 = (tmp_dst_2 + (num1[i] * num2[i]));
};
	tmp_dst = ((int32_t) tmp_dst_2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_dp4a_u32_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t tmp_dst_2;
	uint32_t num1[4];
	uint32_t num2[4];
	int32_t i;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst_2 = src3;
	;;
	extractAndZeroExt_4(src1, num1);
	;;
	extractAndZeroExt_4(src2, num2);
	for(i = 0; i < 4; i++) {
		tmp_dst_2 = (tmp_dst_2 + (num1[i] * num2[i]));
};
	tmp_dst = tmp_dst_2;
	dst = tmp_dst;
	return dst;
}


float execute_ex2_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = 0.0;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		if (((src1 == 0.0) || (fpclassify(src1) == FP_ZERO && signbit(src1)) || (fpclassify(src1) == FP_SUBNORMAL))) {
		tmp_dst = 1.0;
	} else {
		tmp_dst = EXP2(src1);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_ex2_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = 0.0;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		if (((src1 == 0.0) || (fpclassify(src1) == FP_ZERO && signbit(src1)) || (fpclassify(src1) == FP_SUBNORMAL))) {
		tmp_dst = 1.0;
	} else {
		tmp_dst = EXP2(src1);
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rm_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


double execute_fma_rm_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rm_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rm_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_DOWNWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rm_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_DOWNWARD));
	dst = tmp_dst;
	return dst;
}


float execute_fma_rn_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_fma_rn_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rn_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rn_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TONEAREST));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rn_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TONEAREST));
	dst = tmp_dst;
	return dst;
}


float execute_fma_rp_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_fma_rp_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rp_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rp_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_UPWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_fma_rz_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rz_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rz_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TOWARDZERO));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TOWARDZERO));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_fns_b32 (uint32_t src1, uint32_t src2, int32_t src3) {
        uint32_t tmp_dst;
	bitstring32_t mask;
	int32_t offset;
	uint32_t base;
	int32_t pos;
	int32_t count;
	int32_t inc;
	uint32_t dst;

        tmp_dst = 4294967295U;
	mask = src1;
	offset = src3;
	base = (src2 & 31U);
	pos = ((int32_t) base);
	if ((offset == 0)) {
		if (((((mask & (1 << pos)) == (1 << pos))) == 1)) {
		tmp_dst = base;
	};
	} else {
		count = (abs(offset) - 1);
		inc = ((offset > 0) ? 1 : (-1));
		while(((pos >= 0) && (pos < 32))) {
		if (((((mask & (1 << pos)) == (1 << pos))) == 1)) {
		if ((count == 0)) {
		tmp_dst = ((uint32_t) pos);
		break
;
	} else {
		count = (count - 1);
	};
	};
		pos = (pos + inc);
};
	};
	dst = tmp_dst;
	return dst;
}


float execute_lg2_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		if (((src1 == 0.0) || (fpclassify(src1) == FP_ZERO && signbit(src1)))) {
		tmp_dst = -INFINITY;
	} else {
		if ((src1 < 0)) {
		tmp_dst = NAN;
	} else {
		tmp_dst = LOG2(src1);
	};
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_lop3_b32 (uint32_t src1, uint32_t src2, uint32_t src3, uint8_t immLut) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = logical_op3(src1, src2, src3, immLut);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad24_hi_s32 (int32_t src1, int32_t src2, int32_t src3) {
        uint64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = MUL24(src1, src2);
	tmp = (tmp >> 16UL);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	tmp_dst = (tmp_dst + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad24_hi_sat_s32 (int32_t src1, int32_t src2, int32_t src3) {
        uint64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = MUL24(src1, src2);
	tmp = (tmp >> 16UL);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_SATURATE_s32(tmp_dst, src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mad24_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = MUL24(src1, src2);
	tmp = (tmp >> 16UL);
	tmp_dst = ((uint32_t) tmp);
	tmp_dst = (tmp_dst + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad24_lo_s32 (int32_t src1, int32_t src2, int32_t src3) {
        uint64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = MUL24(src1, src2);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	tmp_dst = (tmp_dst + src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mad24_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = MUL24(src1, src2);
	tmp_dst = ((uint32_t) tmp);
	tmp_dst = (tmp_dst + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_madc_hi_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_madc_hi_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_madc_hi_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32UL);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_madc_hi_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_madc_lo_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_madc_lo_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_madc_lo_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_mad_hi_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_mad_hi_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_mad_hi_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32UL);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_mad_hi_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int16_t execute_mad_hi_s16 (int16_t src1, int16_t src2, int16_t src3) {
        int32_t tmp;
	int16_t tmp_mul;
	int16_t tmp_dst;
	int16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 16);
	tmp_mul = ((int16_t) ((uint16_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad_hi_s32 (int32_t src1, int32_t src2, int32_t src3) {
        int64_t tmp;
	int32_t tmp_mul;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int64_t execute_mad_hi_s64 (int64_t src1, int64_t src2, int64_t src3) {
        my_int128_t tmp;
	int64_t tmp_mul;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad_hi_sat_s32 (int32_t src1, int32_t src2, int32_t src3) {
        int64_t tmp;
	int32_t tmp_mul;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_SATURATE_s32(tmp_mul, src3);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mad_hi_u16 (uint16_t src1, uint16_t src2, uint16_t src3) {
        uint32_t tmp;
	uint16_t tmp_mul;
	uint16_t tmp_dst;
	uint16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = SHR(tmp, 16U);
	tmp_mul = ((uint16_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mad_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp;
	uint32_t tmp_mul;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32UL);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad_lo_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_mad_lo_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_mad_lo_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_mad_lo_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int16_t execute_mad_lo_s16 (int16_t src1, int16_t src2, int16_t src3) {
        int32_t tmp;
	int16_t tmp_mul;
	int16_t tmp_dst;
	int16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((int16_t) ((uint16_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad_lo_s32 (int32_t src1, int32_t src2, int32_t src3) {
        int64_t tmp;
	int32_t tmp_mul;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int64_t execute_mad_lo_s64 (int64_t src1, int64_t src2, int64_t src3) {
        my_int128_t tmp;
	int64_t tmp_mul;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mad_lo_u16 (uint16_t src1, uint16_t src2, uint16_t src3) {
        uint32_t tmp;
	uint16_t tmp_mul;
	uint16_t tmp_dst;
	uint16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint16_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mad_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp;
	uint32_t tmp_mul;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mad_lo_u64 (uint64_t src1, uint64_t src2, uint64_t src3) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rm_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rm_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rm_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_DOWNWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rm_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_DOWNWARD));
	dst = tmp_dst;
	return dst;
}


float execute_mad_rn_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_mad_rn_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rn_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rn_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TONEAREST));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rn_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TONEAREST));
	dst = tmp_dst;
	return dst;
}


float execute_mad_rp_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_mad_rp_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rp_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rp_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_UPWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rp_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_UPWARD));
	dst = tmp_dst;
	return dst;
}


float execute_mad_rz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_mad_rz_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rz_ftz_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rz_ftz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	src1 = FTZ(src1);
	src2 = FTZ(src2);
	src3 = FTZ(src3);
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TOWARDZERO));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mad_rz_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_TOWARDZERO));
	dst = tmp_dst;
	return dst;
}


int32_t execute_mad_wide_s16 (int16_t src1, int16_t src2, int32_t src3) {
        int32_t tmp;
	int32_t tmp_mul;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = tmp;
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


int64_t execute_mad_wide_s32 (int32_t src1, int32_t src2, int64_t src3) {
        int64_t tmp;
	int64_t tmp_mul;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = tmp;
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mad_wide_u16 (uint16_t src1, uint16_t src2, uint32_t src3) {
        uint32_t tmp;
	uint32_t tmp_mul;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = tmp;
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mad_wide_u32 (uint32_t src1, uint32_t src2, uint64_t src3) {
        uint64_t tmp;
	uint64_t tmp_mul;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_mul = tmp;
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


float execute_max_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fmaxf_ptx(src1, src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_max_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fmax_ptx(src1, src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_max_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fmaxf_ptx(src1, src2);
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_max_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_max_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_max_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_max_u16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_max_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_max_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = MAX(src1, src2);
	dst = tmp_dst;
	return dst;
}


float execute_min_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fminf_ptx(src1, src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_min_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fmin_ptx(src1, src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_min_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	if (isnan(src1)) {
		tmp_dst = src2;
	} else {
		if (isnan(src2)) {
		tmp_dst = src1;
	} else {
		tmp_dst = fminf_ptx(src1, src2);
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_min_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_min_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_min_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_min_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_min_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mov_b16 (uint16_t src1) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mov_b32 (uint32_t src1) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mov_b64 (uint64_t src1) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


float execute_mov_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


double execute_mov_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


int16_t execute_mov_s16 (int16_t src1) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


int32_t execute_mov_s32 (int32_t src1) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


int64_t execute_mov_s64 (int64_t src1) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mov_u16 (uint16_t src1) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mov_u32 (uint32_t src1) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mov_u64 (uint64_t src1) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


int32_t execute_mul24_hi_s32 (int32_t src1, int32_t src2) {
        uint64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = MUL24(src1, src2);
	tmp = (tmp >> 16UL);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mul24_hi_u32 (uint32_t src1, uint32_t src2) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = MUL24(src1, src2);
	tmp = (tmp >> 16UL);
	tmp_dst = ((uint32_t) tmp);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mul24_lo_u32 (uint32_t src1, uint32_t src2) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = MUL24(src1, src2);
	tmp_dst = ((uint32_t) tmp);
	dst = tmp_dst;
	return dst;
}


float execute_mul_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = (src1 * src2);
	dst = tmp_dst;
	return dst;
}


double execute_mul_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = (src1 * src2);
	dst = tmp_dst;
	return dst;
}


float execute_mul_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = (src1 * src2);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = SATURATE((src1 * src2));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_mul_hi_s16 (int16_t src1, int16_t src2) {
        int32_t tmp;
	int16_t tmp_dst;
	int16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 16);
	tmp_dst = ((int16_t) ((uint16_t) tmp));
	dst = tmp_dst;
	return dst;
}


int32_t execute_mul_hi_s32 (int32_t src1, int32_t src2) {
        int64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mul_hi_u16 (uint16_t src1, uint16_t src2) {
        uint32_t tmp;
	uint16_t tmp_dst;
	uint16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = SHR(tmp, 16U);
	tmp_dst = ((uint16_t) tmp);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mul_hi_u32 (uint32_t src1, uint32_t src2) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32UL);
	tmp_dst = ((uint32_t) tmp);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mul_hi_u64 (uint64_t src1, uint64_t src2) {
        my_uint128_t tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_dst = ((uint64_t) tmp);
	dst = tmp_dst;
	return dst;
}


int16_t execute_mul_lo_s16 (int16_t src1, int16_t src2) {
        int32_t tmp;
	int16_t tmp_dst;
	int16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((int16_t) ((uint16_t) tmp));
	dst = tmp_dst;
	return dst;
}


int32_t execute_mul_lo_s32 (int32_t src1, int32_t src2) {
        int64_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((int32_t) ((uint32_t) tmp));
	dst = tmp_dst;
	return dst;
}


int64_t execute_mul_lo_s64 (int64_t src1, int64_t src2) {
        my_int128_t tmp;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((int64_t) ((uint64_t) tmp));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mul_lo_u32 (uint32_t src1, uint32_t src2) {
        uint64_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((uint32_t) tmp);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mul_lo_u64 (uint64_t src1, uint64_t src2) {
        my_uint128_t tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((uint64_t) tmp);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rm_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


double execute_mul_rm_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rm_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = MUL_ROUND(src1, src2, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rm_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_DOWNWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rm_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_DOWNWARD));
	dst = tmp_dst;
	return dst;
}


float execute_mul_rn_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_mul_rn_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rn_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rn_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_TONEAREST));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rn_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_TONEAREST));
	dst = tmp_dst;
	return dst;
}


float execute_mul_rp_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_mul_rp_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rp_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = MUL_ROUND(src1, src2, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rp_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_UPWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rp_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_UPWARD));
	dst = tmp_dst;
	return dst;
}


float execute_mul_rz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_mul_rz_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rz_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = MUL_ROUND(src1, src2, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rz_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_TOWARDZERO));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_mul_rz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE(MUL_ROUND(src1, src2, FE_TOWARDZERO));
	dst = tmp_dst;
	return dst;
}


float execute_mul_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        ;;
	tmp_dst = SATURATE((src1 * src2));
	dst = tmp_dst;
	return dst;
}


int32_t execute_mul_wide_s16 (int16_t src1, int16_t src2) {
        int32_t tmp;
	int32_t tmp_dst;
	int32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = tmp;
	dst = tmp_dst;
	return dst;
}


int64_t execute_mul_wide_s32 (int32_t src1, int32_t src2) {
        int64_t tmp;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = tmp;
	dst = tmp_dst;
	return dst;
}


uint32_t execute_mul_wide_u16 (uint16_t src1, uint16_t src2) {
        uint32_t tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = tmp;
	dst = tmp_dst;
	return dst;
}


uint64_t execute_mul_wide_u32 (uint32_t src1, uint32_t src2) {
        uint64_t tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = tmp;
	dst = tmp_dst;
	return dst;
}


float execute_neg_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = ((-1) * src1);
	dst = tmp_dst;
	return dst;
}


double execute_neg_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = ((-1) * src1);
	dst = tmp_dst;
	return dst;
}


float execute_neg_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = ((-1) * src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int16_t execute_neg_s16 (int16_t src1) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = ((-1) * src1);
	dst = tmp_dst;
	return dst;
}


int32_t execute_neg_s32 (int32_t src1) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = ((-1) * src1);
	dst = tmp_dst;
	return dst;
}


int64_t execute_neg_s64 (int64_t src1) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = ((-1L) * src1);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_not_b16 (uint16_t src1) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = ~(src1);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_not_pred (unsigned int src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = !(src1);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_not_b32 (uint32_t src1) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = ~(src1);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_or_pred (unsigned int src1, unsigned int src2) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (src1 | src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_or_b16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = (src1 | src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_or_b32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = (src1 | src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_or_b64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = (src1 | src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_popc_b32 (uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t tmp_src;
	uint32_t dst;

        tmp_dst = 0U;
	tmp_src = src2;
	while((tmp_src != 0U)) {
		if ((tmp_src & 1U)) {
		tmp_dst = (tmp_dst + 1U);
	};
		tmp_src = SHR(tmp_src, 1U);
};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_popc_b64 (uint64_t src2) {
        uint32_t tmp_dst;
	uint64_t tmp_src;
	uint32_t dst;

        tmp_dst = 0U;
	tmp_src = src2;
	while((tmp_src != 0UL)) {
		if ((tmp_src & 1UL)) {
		tmp_dst = (tmp_dst + 1U);
	};
		tmp_src = (tmp_src >> 1UL);
};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 15U);
	ctl_1 = (SHR(src3, 4U) & 15U);
	ctl_2 = (SHR(src3, 8U) & 15U);
	ctl_3 = (SHR(src3, 12U) & 15U);
	tmp_byte_0 = ReadByte(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_b4e_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_b4e(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_b4e(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_b4e(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_b4e(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_ecl_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_ecl(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_ecl(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_ecl(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_ecl(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_ecr_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_ecr(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_ecr(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_ecr(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_ecr(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_rc16_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_rc16(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_rc16(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_rc16(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_rc16(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_rc8_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_rc8(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_rc8(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_rc8(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_rc8(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = RCP(src1);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = RCP(src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rm_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = RCP_ROUND(src1, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


double execute_rcp_rm_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = RCP_ROUND(src1, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rn_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = RCP_ROUND(src1, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_rcp_rn_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = RCP_ROUND(src1, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rn_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = RCP_ROUND(src1, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rp_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = RCP_ROUND(src1, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_rcp_rp_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = RCP_ROUND(src1, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rp_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = RCP_ROUND(src1, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


double execute_rcp_rz_f64 (double src1) {
        double tmp_dst;
	double dst;

        tmp_dst = RCP_ROUND(src1, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rz_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = RCP_ROUND(src1, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_rem_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        if ((src2 == 0)) {
		tmp_dst = -1;
	} else {
		if ((src2 < 0)) {
		tmp_dst = MACHINE_SPECIFIC_execute_rem_divide_by_neg(src1, src2);
	} else {
		tmp_dst = (src1 % src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


int64_t execute_rem_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        if ((src2 == 0L)) {
		tmp_dst = -1;
	} else {
		if ((src2 < 0L)) {
		tmp_dst = MACHINE_SPECIFIC_execute_rem_divide_by_neg(src1, src2);
	} else {
		tmp_dst = (src1 % src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


uint16_t execute_rem_u16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        if ((src2 == 0)) {
		tmp_dst = (src1);
	} else {
		tmp_dst = (src1 % src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_rem_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        if ((src2 == 0UL)) {
		tmp_dst = (src1);
	} else {
		tmp_dst = (src1 % src2);
	};
	dst = tmp_dst;
	return dst;
}


float execute_rsqrt_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        if ((fpclassify(src1) == FP_ZERO && signbit(src1))) {
		tmp_dst = -INFINITY;
	} else {
		if ((src1 == 0.0)) {
		tmp_dst = INFINITY;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = 0.0;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((src1 < 0)) {
		tmp_dst = NAN;
	} else {
		tmp_dst = RSQRT(src1);
	};
	};
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_rsqrt_approx_f64 (double src1) {
        double tmp_dst;
	double dst;

        if ((fpclassify(src1) == FP_ZERO && signbit(src1))) {
		tmp_dst = -INFINITY;
	} else {
		if ((src1 == 0.0)) {
		tmp_dst = INFINITY;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = 0.0;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((src1 < 0)) {
		tmp_dst = NAN;
	} else {
		tmp_dst = RSQRT(src1);
	};
	};
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


int16_t execute_sad_s16 (int16_t src1, int16_t src2, int16_t src3) {
        int16_t tmp_sub;
	int16_t tmp_dst;
	int16_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


int32_t execute_sad_s32 (int32_t src1, int32_t src2, int32_t src3) {
        int32_t tmp_sub;
	int32_t tmp_dst;
	int32_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


int64_t execute_sad_s64 (int64_t src1, int64_t src2, int64_t src3) {
        int64_t tmp_sub;
	int64_t tmp_dst;
	int64_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_sad_u16 (uint16_t src1, uint16_t src2, uint16_t src3) {
        uint16_t tmp_sub;
	uint16_t tmp_dst;
	uint16_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_sad_u32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t tmp_sub;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_sad_u64 (uint64_t src1, uint64_t src2, uint64_t src3) {
        uint64_t tmp_sub;
	uint64_t tmp_dst;
	uint64_t dst;

        tmp_sub = ((src1 < src2) ? (src2 - src1) : (src1 - src2));
	tmp_dst = (tmp_sub + src3);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_mov_pred (unsigned int src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = src1;
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gtu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gtu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gtu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hi_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hi_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hi_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_hs_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_hs_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_hs_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_leu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_leu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_leu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_le_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_le_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_le_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lo_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lo_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lo_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ls_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 <= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ls_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ls_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 <= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ltu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ltu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ltu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_lt_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 < src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_lt_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_lt_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 < src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_nan_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_nan_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_nan_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_f32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_s32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_s16 (int16_t src1, int16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_u32_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_neu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_neu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_neu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ne_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ne_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ne_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 != src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_ftz_f32_f32 (float src1, float src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = (pred2 ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_ftz_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_ftz_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_s32_f32 (float src1, float src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_s32_f64 (double src1, double src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_num_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_num_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_num_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = !(isnan(src1) || isnan(src2));
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_equ_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_eq_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_geu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ge_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gtu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_gt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hi_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_hs_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_leu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_le_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lo_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ls_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ltu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_lt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_nan_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_neu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_ne_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


unsigned int execute_setp_num_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	dst = tmp_dst;
	return dst;
}


struct retval_setp_q_eq_and_b16  execute_setp_q_eq_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_b32  execute_setp_q_eq_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_b64  execute_setp_q_eq_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_f32  execute_setp_q_eq_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_f64  execute_setp_q_eq_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_b16  execute_setp_q_eq_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_b32  execute_setp_q_eq_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_b64  execute_setp_q_eq_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_f32  execute_setp_q_eq_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_f64  execute_setp_q_eq_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_ftz_f32  execute_setp_q_eq_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_s16  execute_setp_q_eq_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_s32  execute_setp_q_eq_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_s64  execute_setp_q_eq_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_u16  execute_setp_q_eq_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_u32  execute_setp_q_eq_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_invert_u64  execute_setp_q_eq_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_s16  execute_setp_q_eq_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_s32  execute_setp_q_eq_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_s64  execute_setp_q_eq_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_u16  execute_setp_q_eq_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_u32  execute_setp_q_eq_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_and_u64  execute_setp_q_eq_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_b16  execute_setp_q_eq_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_b32  execute_setp_q_eq_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_b64  execute_setp_q_eq_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_f32  execute_setp_q_eq_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_f64  execute_setp_q_eq_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_ftz_f32  execute_setp_q_eq_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_b16  execute_setp_q_eq_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_b32  execute_setp_q_eq_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_b64  execute_setp_q_eq_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_f32  execute_setp_q_eq_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_f64  execute_setp_q_eq_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_ftz_f32  execute_setp_q_eq_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_b16  execute_setp_q_eq_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_b32  execute_setp_q_eq_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_b64  execute_setp_q_eq_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_f32  execute_setp_q_eq_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_f64  execute_setp_q_eq_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_ftz_f32  execute_setp_q_eq_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_s16  execute_setp_q_eq_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_s32  execute_setp_q_eq_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_s64  execute_setp_q_eq_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_u16  execute_setp_q_eq_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_u32  execute_setp_q_eq_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_invert_u64  execute_setp_q_eq_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_eq_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_s16  execute_setp_q_eq_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_s32  execute_setp_q_eq_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_s64  execute_setp_q_eq_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_u16  execute_setp_q_eq_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_u32  execute_setp_q_eq_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_or_u64  execute_setp_q_eq_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_eq_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_s16  execute_setp_q_eq_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_s32  execute_setp_q_eq_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_s64  execute_setp_q_eq_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_u16  execute_setp_q_eq_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_u32  execute_setp_q_eq_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_u64  execute_setp_q_eq_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_eq_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_and_f32  execute_setp_q_equ_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_equ_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_and_f64  execute_setp_q_equ_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_equ_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_and_invert_f32  execute_setp_q_equ_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_equ_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_and_invert_f64  execute_setp_q_equ_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_equ_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_and_invert_ftz_f32  execute_setp_q_equ_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_equ_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_f32  execute_setp_q_equ_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_equ_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_f64  execute_setp_q_equ_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_equ_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_ftz_f32  execute_setp_q_equ_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_equ_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_or_f32  execute_setp_q_equ_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_equ_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_or_f64  execute_setp_q_equ_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_equ_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_or_ftz_f32  execute_setp_q_equ_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_equ_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_or_invert_f64  execute_setp_q_equ_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_equ_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_or_invert_ftz_f32  execute_setp_q_equ_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_equ_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_xor_f32  execute_setp_q_equ_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_equ_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_xor_f64  execute_setp_q_equ_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_equ_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_xor_ftz_f32  execute_setp_q_equ_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_equ_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_xor_invert_f32  execute_setp_q_equ_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_equ_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_equ_xor_invert_f64  execute_setp_q_equ_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_equ_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_b16  execute_setp_q_eq_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_b32  execute_setp_q_eq_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_b64  execute_setp_q_eq_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_f32  execute_setp_q_eq_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_f64  execute_setp_q_eq_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_ftz_f32  execute_setp_q_eq_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_b16  execute_setp_q_eq_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_b32  execute_setp_q_eq_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_b64  execute_setp_q_eq_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_f32  execute_setp_q_eq_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_f64  execute_setp_q_eq_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_ftz_f32  execute_setp_q_eq_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_s16  execute_setp_q_eq_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_s32  execute_setp_q_eq_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_s64  execute_setp_q_eq_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_u16  execute_setp_q_eq_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_u32  execute_setp_q_eq_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_invert_u64  execute_setp_q_eq_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_s16  execute_setp_q_eq_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_s32  execute_setp_q_eq_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_s64  execute_setp_q_eq_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_u16  execute_setp_q_eq_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_u32  execute_setp_q_eq_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_eq_xor_u64  execute_setp_q_eq_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 == src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_eq_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_f32  execute_setp_q_ge_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_f64  execute_setp_q_ge_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_ftz_f32  execute_setp_q_ge_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_f32  execute_setp_q_ge_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_f64  execute_setp_q_ge_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_ftz_f32  execute_setp_q_ge_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_s16  execute_setp_q_ge_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_s32  execute_setp_q_ge_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_s64  execute_setp_q_ge_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_u16  execute_setp_q_ge_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_u32  execute_setp_q_ge_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_invert_u64  execute_setp_q_ge_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_s16  execute_setp_q_ge_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_s32  execute_setp_q_ge_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_s64  execute_setp_q_ge_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_u16  execute_setp_q_ge_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_u32  execute_setp_q_ge_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_and_u64  execute_setp_q_ge_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_f32  execute_setp_q_ge_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_f64  execute_setp_q_ge_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_ftz_f32  execute_setp_q_ge_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_f32  execute_setp_q_ge_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_ftz_f32  execute_setp_q_ge_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_f32  execute_setp_q_ge_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_f64  execute_setp_q_ge_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_ftz_f32  execute_setp_q_ge_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_s16  execute_setp_q_ge_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_s32  execute_setp_q_ge_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_s64  execute_setp_q_ge_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_u16  execute_setp_q_ge_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_u32  execute_setp_q_ge_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_invert_u64  execute_setp_q_ge_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ge_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_s16  execute_setp_q_ge_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_s32  execute_setp_q_ge_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_s64  execute_setp_q_ge_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_u16  execute_setp_q_ge_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_u32  execute_setp_q_ge_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_or_u64  execute_setp_q_ge_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ge_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_s16  execute_setp_q_ge_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_s32  execute_setp_q_ge_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_u16  execute_setp_q_ge_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_u32  execute_setp_q_ge_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_u64  execute_setp_q_ge_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ge_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_f32  execute_setp_q_geu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_f64  execute_setp_q_geu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_ftz_f32  execute_setp_q_geu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_invert_f32  execute_setp_q_geu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_invert_f64  execute_setp_q_geu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_and_invert_ftz_f32  execute_setp_q_geu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_f32  execute_setp_q_geu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_geu_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_f64  execute_setp_q_geu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_geu_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_ftz_f32  execute_setp_q_geu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_geu_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_f32  execute_setp_q_geu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_f64  execute_setp_q_geu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_ftz_f32  execute_setp_q_geu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_geu_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_invert_f32  execute_setp_q_geu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_invert_f64  execute_setp_q_geu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_or_invert_ftz_f32  execute_setp_q_geu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_geu_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_f32  execute_setp_q_geu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_f64  execute_setp_q_geu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_ftz_f32  execute_setp_q_geu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_invert_f32  execute_setp_q_geu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_invert_f64  execute_setp_q_geu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_geu_xor_invert_ftz_f32  execute_setp_q_geu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_geu_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_f32  execute_setp_q_ge_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_f64  execute_setp_q_ge_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_ftz_f32  execute_setp_q_ge_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_f32  execute_setp_q_ge_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_f64  execute_setp_q_ge_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_ftz_f32  execute_setp_q_ge_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_s16  execute_setp_q_ge_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_s32  execute_setp_q_ge_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_s64  execute_setp_q_ge_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_u16  execute_setp_q_ge_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_u32  execute_setp_q_ge_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_invert_u64  execute_setp_q_ge_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_s16  execute_setp_q_ge_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_s32  execute_setp_q_ge_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_s64  execute_setp_q_ge_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_u16  execute_setp_q_ge_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_u32  execute_setp_q_ge_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ge_xor_u64  execute_setp_q_ge_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ge_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_f32  execute_setp_q_gt_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_f64  execute_setp_q_gt_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_ftz_f32  execute_setp_q_gt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_f32  execute_setp_q_gt_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_f64  execute_setp_q_gt_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_ftz_f32  execute_setp_q_gt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_s32  execute_setp_q_gt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_s64  execute_setp_q_gt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_u16  execute_setp_q_gt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_invert_u32  execute_setp_q_gt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_s16  execute_setp_q_gt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_s32  execute_setp_q_gt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_s64  execute_setp_q_gt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_u16  execute_setp_q_gt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_u32  execute_setp_q_gt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_and_u64  execute_setp_q_gt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_f32  execute_setp_q_gt_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_f64  execute_setp_q_gt_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_f32  execute_setp_q_gt_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_f64  execute_setp_q_gt_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_ftz_f32  execute_setp_q_gt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_f32  execute_setp_q_gt_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_f64  execute_setp_q_gt_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_ftz_f32  execute_setp_q_gt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_s16  execute_setp_q_gt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_s32  execute_setp_q_gt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_s64  execute_setp_q_gt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_u16  execute_setp_q_gt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_u32  execute_setp_q_gt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_invert_u64  execute_setp_q_gt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gt_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_s16  execute_setp_q_gt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_s32  execute_setp_q_gt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_s64  execute_setp_q_gt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_u16  execute_setp_q_gt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_u32  execute_setp_q_gt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_or_u64  execute_setp_q_gt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gt_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_s16  execute_setp_q_gt_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_s32  execute_setp_q_gt_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_s64  execute_setp_q_gt_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_u16  execute_setp_q_gt_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_u32  execute_setp_q_gt_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_u64  execute_setp_q_gt_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gt_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_and_f32  execute_setp_q_gtu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gtu_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_and_f64  execute_setp_q_gtu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gtu_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_and_invert_f32  execute_setp_q_gtu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gtu_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_and_invert_f64  execute_setp_q_gtu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gtu_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_f32  execute_setp_q_gtu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gtu_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_f64  execute_setp_q_gtu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gtu_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_ftz_f32  execute_setp_q_gtu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_gtu_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_or_f32  execute_setp_q_gtu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gtu_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_or_f64  execute_setp_q_gtu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_gtu_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_or_invert_f32  execute_setp_q_gtu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gtu_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_or_invert_f64  execute_setp_q_gtu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gtu_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_or_invert_ftz_f32  execute_setp_q_gtu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_gtu_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_f32  execute_setp_q_gtu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_f64  execute_setp_q_gtu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_ftz_f32  execute_setp_q_gtu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_invert_f32  execute_setp_q_gtu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_invert_f64  execute_setp_q_gtu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gtu_xor_invert_ftz_f32  execute_setp_q_gtu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gtu_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_f32  execute_setp_q_gt_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_f64  execute_setp_q_gt_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_f32  execute_setp_q_gt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_f64  execute_setp_q_gt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_ftz_f32  execute_setp_q_gt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_s16  execute_setp_q_gt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_s32  execute_setp_q_gt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_s64  execute_setp_q_gt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_u16  execute_setp_q_gt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_u32  execute_setp_q_gt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_invert_u64  execute_setp_q_gt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_s16  execute_setp_q_gt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_s32  execute_setp_q_gt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_s64  execute_setp_q_gt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_u16  execute_setp_q_gt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_u32  execute_setp_q_gt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_gt_xor_u64  execute_setp_q_gt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_gt_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_and_invert_u16  execute_setp_q_hi_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_and_invert_u32  execute_setp_q_hi_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_and_invert_u64  execute_setp_q_hi_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_and_u16  execute_setp_q_hi_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hi_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_and_u32  execute_setp_q_hi_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hi_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_invert_u16  execute_setp_q_hi_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_invert_u32  execute_setp_q_hi_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_invert_u64  execute_setp_q_hi_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hi_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_u16  execute_setp_q_hi_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hi_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_u32  execute_setp_q_hi_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hi_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_or_u64  execute_setp_q_hi_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hi_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_u16  execute_setp_q_hi_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_hi_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_u32  execute_setp_q_hi_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_hi_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_invert_u16  execute_setp_q_hi_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_invert_u32  execute_setp_q_hi_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_invert_u64  execute_setp_q_hi_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_u16  execute_setp_q_hi_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_u32  execute_setp_q_hi_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hi_xor_u64  execute_setp_q_hi_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 > src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hi_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_invert_u16  execute_setp_q_hs_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_invert_u32  execute_setp_q_hs_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_invert_u64  execute_setp_q_hs_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_u16  execute_setp_q_hs_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_u32  execute_setp_q_hs_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_and_u64  execute_setp_q_hs_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_invert_u16  execute_setp_q_hs_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_invert_u32  execute_setp_q_hs_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_invert_u64  execute_setp_q_hs_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_hs_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_u16  execute_setp_q_hs_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_u32  execute_setp_q_hs_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_or_u64  execute_setp_q_hs_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_hs_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_u16  execute_setp_q_hs_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_hs_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_u32  execute_setp_q_hs_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_hs_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_invert_u16  execute_setp_q_hs_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_invert_u32  execute_setp_q_hs_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_invert_u64  execute_setp_q_hs_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_u16  execute_setp_q_hs_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_u32  execute_setp_q_hs_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_hs_xor_u64  execute_setp_q_hs_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 >= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_hs_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_f32  execute_setp_q_le_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_f64  execute_setp_q_le_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_ftz_f32  execute_setp_q_le_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_f32  execute_setp_q_le_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_f64  execute_setp_q_le_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_ftz_f32  execute_setp_q_le_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_s16  execute_setp_q_le_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_s32  execute_setp_q_le_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_s64  execute_setp_q_le_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_u16  execute_setp_q_le_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_u32  execute_setp_q_le_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_invert_u64  execute_setp_q_le_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_s16  execute_setp_q_le_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_s32  execute_setp_q_le_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_s64  execute_setp_q_le_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_u16  execute_setp_q_le_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_u32  execute_setp_q_le_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_and_u64  execute_setp_q_le_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_f32  execute_setp_q_le_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_f64  execute_setp_q_le_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_ftz_f32  execute_setp_q_le_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_f32  execute_setp_q_le_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_f64  execute_setp_q_le_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_ftz_f32  execute_setp_q_le_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_f32  execute_setp_q_le_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_f64  execute_setp_q_le_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_ftz_f32  execute_setp_q_le_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_s16  execute_setp_q_le_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_s32  execute_setp_q_le_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_s64  execute_setp_q_le_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_u16  execute_setp_q_le_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_u32  execute_setp_q_le_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_invert_u64  execute_setp_q_le_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_le_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_s16  execute_setp_q_le_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_s32  execute_setp_q_le_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_s64  execute_setp_q_le_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_u16  execute_setp_q_le_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_u32  execute_setp_q_le_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_or_u64  execute_setp_q_le_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_le_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_s16  execute_setp_q_le_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_s32  execute_setp_q_le_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_s64  execute_setp_q_le_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_u32  execute_setp_q_le_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_u64  execute_setp_q_le_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_le_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_f32  execute_setp_q_leu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_leu_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_f64  execute_setp_q_leu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_leu_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_ftz_f32  execute_setp_q_leu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_leu_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_invert_f32  execute_setp_q_leu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_invert_f64  execute_setp_q_leu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_and_invert_ftz_f32  execute_setp_q_leu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_f32  execute_setp_q_leu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_leu_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_f64  execute_setp_q_leu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_leu_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_ftz_f32  execute_setp_q_leu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_leu_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_or_f64  execute_setp_q_leu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_leu_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_or_ftz_f32  execute_setp_q_leu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_leu_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_or_invert_f32  execute_setp_q_leu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_or_invert_f64  execute_setp_q_leu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_or_invert_ftz_f32  execute_setp_q_leu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_leu_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_f32  execute_setp_q_leu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_f64  execute_setp_q_leu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_ftz_f32  execute_setp_q_leu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_invert_f32  execute_setp_q_leu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_invert_f64  execute_setp_q_leu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_leu_xor_invert_ftz_f32  execute_setp_q_leu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_leu_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_f32  execute_setp_q_le_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_f64  execute_setp_q_le_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_f32  execute_setp_q_le_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_f64  execute_setp_q_le_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_ftz_f32  execute_setp_q_le_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_s16  execute_setp_q_le_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_s32  execute_setp_q_le_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_s64  execute_setp_q_le_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_u16  execute_setp_q_le_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_u32  execute_setp_q_le_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_invert_u64  execute_setp_q_le_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_s16  execute_setp_q_le_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_s32  execute_setp_q_le_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_s64  execute_setp_q_le_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_u16  execute_setp_q_le_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_u32  execute_setp_q_le_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_le_xor_u64  execute_setp_q_le_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_le_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_invert_u16  execute_setp_q_lo_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_invert_u32  execute_setp_q_lo_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_invert_u64  execute_setp_q_lo_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_u16  execute_setp_q_lo_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_u32  execute_setp_q_lo_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_and_u64  execute_setp_q_lo_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_invert_u16  execute_setp_q_lo_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_invert_u32  execute_setp_q_lo_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_invert_u64  execute_setp_q_lo_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lo_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_u16  execute_setp_q_lo_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_u32  execute_setp_q_lo_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_or_u64  execute_setp_q_lo_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lo_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_u16  execute_setp_q_lo_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lo_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_u32  execute_setp_q_lo_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lo_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_invert_u16  execute_setp_q_lo_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_invert_u32  execute_setp_q_lo_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_invert_u64  execute_setp_q_lo_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_u16  execute_setp_q_lo_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_u32  execute_setp_q_lo_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lo_xor_u64  execute_setp_q_lo_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lo_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_invert_u16  execute_setp_q_ls_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_invert_u32  execute_setp_q_ls_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_invert_u64  execute_setp_q_ls_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_u16  execute_setp_q_ls_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ls_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_u32  execute_setp_q_ls_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ls_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_and_u64  execute_setp_q_ls_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ls_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_or_invert_u16  execute_setp_q_ls_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_or_invert_u32  execute_setp_q_ls_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_or_invert_u64  execute_setp_q_ls_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ls_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_or_u16  execute_setp_q_ls_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ls_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_or_u64  execute_setp_q_ls_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ls_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_u16  execute_setp_q_ls_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ls_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_u32  execute_setp_q_ls_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ls_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_u64  execute_setp_q_ls_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ls_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_xor_invert_u16  execute_setp_q_ls_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ls_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_xor_invert_u64  execute_setp_q_ls_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ls_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_xor_u16  execute_setp_q_ls_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ls_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_xor_u32  execute_setp_q_ls_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ls_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ls_xor_u64  execute_setp_q_ls_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 <= src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ls_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_f32  execute_setp_q_lt_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_f64  execute_setp_q_lt_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_f32  execute_setp_q_lt_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_f64  execute_setp_q_lt_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_ftz_f32  execute_setp_q_lt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_s16  execute_setp_q_lt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_s32  execute_setp_q_lt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_s64  execute_setp_q_lt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_u16  execute_setp_q_lt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_u32  execute_setp_q_lt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_invert_u64  execute_setp_q_lt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_s16  execute_setp_q_lt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_s32  execute_setp_q_lt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_s64  execute_setp_q_lt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_u16  execute_setp_q_lt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_u32  execute_setp_q_lt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_and_u64  execute_setp_q_lt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_f32  execute_setp_q_lt_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_f64  execute_setp_q_lt_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_ftz_f32  execute_setp_q_lt_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_f32  execute_setp_q_lt_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_f64  execute_setp_q_lt_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_ftz_f32  execute_setp_q_lt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_f32  execute_setp_q_lt_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_f64  execute_setp_q_lt_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_ftz_f32  execute_setp_q_lt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_s16  execute_setp_q_lt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_s32  execute_setp_q_lt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_s64  execute_setp_q_lt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_u16  execute_setp_q_lt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_u32  execute_setp_q_lt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_invert_u64  execute_setp_q_lt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_lt_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_s16  execute_setp_q_lt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_s32  execute_setp_q_lt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_s64  execute_setp_q_lt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_u16  execute_setp_q_lt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_u32  execute_setp_q_lt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_or_u64  execute_setp_q_lt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_lt_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_s16  execute_setp_q_lt_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_s32  execute_setp_q_lt_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_s64  execute_setp_q_lt_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_u16  execute_setp_q_lt_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_u64  execute_setp_q_lt_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_lt_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_and_f32  execute_setp_q_ltu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_and_f64  execute_setp_q_ltu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_and_ftz_f32  execute_setp_q_ltu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_and_invert_f64  execute_setp_q_ltu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ltu_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_and_invert_ftz_f32  execute_setp_q_ltu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ltu_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_f32  execute_setp_q_ltu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ltu_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_f64  execute_setp_q_ltu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ltu_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_ftz_f32  execute_setp_q_ltu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ltu_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_f32  execute_setp_q_ltu_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_f64  execute_setp_q_ltu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_ftz_f32  execute_setp_q_ltu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_invert_f32  execute_setp_q_ltu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_invert_f64  execute_setp_q_ltu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_or_invert_ftz_f32  execute_setp_q_ltu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ltu_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_xor_f32  execute_setp_q_ltu_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ltu_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_xor_f64  execute_setp_q_ltu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ltu_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_xor_ftz_f32  execute_setp_q_ltu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ltu_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_xor_invert_f32  execute_setp_q_ltu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ltu_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ltu_xor_invert_f64  execute_setp_q_ltu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ltu_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_f32  execute_setp_q_lt_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_f64  execute_setp_q_lt_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_ftz_f32  execute_setp_q_lt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_f32  execute_setp_q_lt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_f64  execute_setp_q_lt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_ftz_f32  execute_setp_q_lt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_s16  execute_setp_q_lt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_s32  execute_setp_q_lt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_s64  execute_setp_q_lt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_u16  execute_setp_q_lt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_u32  execute_setp_q_lt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_invert_u64  execute_setp_q_lt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_s16  execute_setp_q_lt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_s32  execute_setp_q_lt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_s64  execute_setp_q_lt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_u16  execute_setp_q_lt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_u32  execute_setp_q_lt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_lt_xor_u64  execute_setp_q_lt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 < src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_lt_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_f32  execute_setp_q_nan_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_nan_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_f64  execute_setp_q_nan_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_nan_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_ftz_f32  execute_setp_q_nan_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_nan_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_invert_f32  execute_setp_q_nan_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_nan_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_invert_f64  execute_setp_q_nan_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_nan_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_and_invert_ftz_f32  execute_setp_q_nan_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_nan_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_f32  execute_setp_q_nan_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_nan_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_f64  execute_setp_q_nan_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_nan_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_ftz_f32  execute_setp_q_nan_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_nan_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_or_f32  execute_setp_q_nan_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_nan_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_or_ftz_f32  execute_setp_q_nan_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_nan_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_or_invert_f32  execute_setp_q_nan_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_nan_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_or_invert_ftz_f32  execute_setp_q_nan_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_nan_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_xor_f32  execute_setp_q_nan_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_nan_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_xor_f64  execute_setp_q_nan_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_nan_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_xor_ftz_f32  execute_setp_q_nan_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_nan_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_xor_invert_f64  execute_setp_q_nan_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_nan_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_nan_xor_invert_ftz_f32  execute_setp_q_nan_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_nan_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_b16  execute_setp_q_ne_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_b32  execute_setp_q_ne_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_b64  execute_setp_q_ne_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_f32  execute_setp_q_ne_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_f64  execute_setp_q_ne_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_b16  execute_setp_q_ne_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_b32  execute_setp_q_ne_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_f32  execute_setp_q_ne_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_f64  execute_setp_q_ne_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_ftz_f32  execute_setp_q_ne_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_s16  execute_setp_q_ne_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_s32  execute_setp_q_ne_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_s64  execute_setp_q_ne_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_u16  execute_setp_q_ne_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_u32  execute_setp_q_ne_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_invert_u64  execute_setp_q_ne_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_and_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_s16  execute_setp_q_ne_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_s32  execute_setp_q_ne_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_s64  execute_setp_q_ne_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_u16  execute_setp_q_ne_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_u32  execute_setp_q_ne_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_and_u64  execute_setp_q_ne_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_and_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_b16  execute_setp_q_ne_b16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_b32  execute_setp_q_ne_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_b64  execute_setp_q_ne_b64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_f32  execute_setp_q_ne_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_f64  execute_setp_q_ne_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_ftz_f32  execute_setp_q_ne_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_b16  execute_setp_q_ne_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_b32  execute_setp_q_ne_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_b64  execute_setp_q_ne_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_f32  execute_setp_q_ne_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_f64  execute_setp_q_ne_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_ftz_f32  execute_setp_q_ne_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_b16  execute_setp_q_ne_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_b32  execute_setp_q_ne_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_f64  execute_setp_q_ne_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_ftz_f32  execute_setp_q_ne_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_s16  execute_setp_q_ne_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_s32  execute_setp_q_ne_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_s64  execute_setp_q_ne_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_u16  execute_setp_q_ne_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_u32  execute_setp_q_ne_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_invert_u64  execute_setp_q_ne_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_ne_or_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_s16  execute_setp_q_ne_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_s32  execute_setp_q_ne_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_s64  execute_setp_q_ne_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_u16  execute_setp_q_ne_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_u32  execute_setp_q_ne_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_or_u64  execute_setp_q_ne_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_ne_or_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_s16  execute_setp_q_ne_s16 (int16_t src1, int16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_s32  execute_setp_q_ne_s32 (int32_t src1, int32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_s64  execute_setp_q_ne_s64 (int64_t src1, int64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_u16  execute_setp_q_ne_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_u32  execute_setp_q_ne_u32 (uint32_t src1, uint32_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_u64  execute_setp_q_ne_u64 (uint64_t src1, uint64_t src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_ne_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_and_f32  execute_setp_q_neu_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_neu_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_and_f64  execute_setp_q_neu_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_neu_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_and_invert_f32  execute_setp_q_neu_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_and_invert_f64  execute_setp_q_neu_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_and_invert_ftz_f32  execute_setp_q_neu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_f32  execute_setp_q_neu_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_neu_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_f64  execute_setp_q_neu_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_neu_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_ftz_f32  execute_setp_q_neu_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_neu_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_or_f64  execute_setp_q_neu_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_neu_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_or_ftz_f32  execute_setp_q_neu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_neu_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_or_invert_f32  execute_setp_q_neu_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_or_invert_f64  execute_setp_q_neu_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_or_invert_ftz_f32  execute_setp_q_neu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_neu_or_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_xor_f64  execute_setp_q_neu_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_neu_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_xor_ftz_f32  execute_setp_q_neu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_neu_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_neu_xor_invert_f32  execute_setp_q_neu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (isnan(src1) || isnan(src2) || (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_neu_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_b16  execute_setp_q_ne_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_b64  execute_setp_q_ne_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_f32  execute_setp_q_ne_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_f64  execute_setp_q_ne_xor_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_ftz_f32  execute_setp_q_ne_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_b16  execute_setp_q_ne_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_b16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_b32  execute_setp_q_ne_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_b32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_b64  execute_setp_q_ne_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_b64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_f64  execute_setp_q_ne_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_ftz_f32  execute_setp_q_ne_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = ((!(isnan(src1) || isnan(src2))) && (src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_s16  execute_setp_q_ne_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_s32  execute_setp_q_ne_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_s64  execute_setp_q_ne_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_u16  execute_setp_q_ne_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_u32  execute_setp_q_ne_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_invert_u64  execute_setp_q_ne_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_invert_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_s16  execute_setp_q_ne_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_s16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_s32  execute_setp_q_ne_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_s32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_s64  execute_setp_q_ne_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_s64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_u16  execute_setp_q_ne_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_u16  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_u32  execute_setp_q_ne_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_u32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_ne_xor_u64  execute_setp_q_ne_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = ((src1 != src2) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_ne_xor_u64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_f32  execute_setp_q_num_and_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_and_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_f64  execute_setp_q_num_and_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_and_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_ftz_f32  execute_setp_q_num_and_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && pred_reg);
	pred_dst_q = ((!pred_tmp) && pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_and_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_invert_f32  execute_setp_q_num_and_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_num_and_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_invert_f64  execute_setp_q_num_and_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_num_and_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_and_invert_ftz_f32  execute_setp_q_num_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp && (!pred_reg));
	pred_dst_q = ((!pred_tmp) && (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_num_and_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_f32  execute_setp_q_num_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_num_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_f64  execute_setp_q_num_f64 (double src1, double src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_num_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_ftz_f32  execute_setp_q_num_ftz_f32 (float src1, float src2) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = pred_tmp;
	pred_dst_q = (!pred_tmp);
	dst = tmp_dst;
	struct retval_setp_q_num_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_or_f32  execute_setp_q_num_or_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_or_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_or_f64  execute_setp_q_num_or_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_or_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_or_ftz_f32  execute_setp_q_num_or_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || pred_reg);
	pred_dst_q = ((!pred_tmp) || pred_reg);
	dst = tmp_dst;
	struct retval_setp_q_num_or_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_or_invert_f32  execute_setp_q_num_or_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_num_or_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_or_invert_f64  execute_setp_q_num_or_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (pred_tmp || (!pred_reg));
	pred_dst_q = ((!pred_tmp) || (!pred_reg));
	dst = tmp_dst;
	struct retval_setp_q_num_or_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_xor_f32  execute_setp_q_num_xor_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_num_xor_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_xor_ftz_f32  execute_setp_q_num_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && pred_reg) || (pred_tmp && (!pred_reg)));
	pred_dst_q = (((!(!pred_tmp)) && pred_reg) || ((!pred_tmp) && (!pred_reg)));
	dst = tmp_dst;
	struct retval_setp_q_num_xor_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_xor_invert_f32  execute_setp_q_num_xor_invert_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_num_xor_invert_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_xor_invert_f64  execute_setp_q_num_xor_invert_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_num_xor_invert_f64  _retval = { dst, pred_dst_q };
	return _retval;
}


struct retval_setp_q_num_xor_invert_ftz_f32  execute_setp_q_num_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred_tmp;
	unsigned int tmp_dst;
	unsigned int pred_dst_q;
	unsigned int dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred_tmp = (!(isnan(src1) || isnan(src2)) ? 1 : 0);
	tmp_dst = (((!pred_tmp) && (!pred_reg)) || (pred_tmp && (!(!pred_reg))));
	pred_dst_q = (((!(!pred_tmp)) && (!pred_reg)) || ((!pred_tmp) && (!(!pred_reg))));
	dst = tmp_dst;
	struct retval_setp_q_num_xor_invert_ftz_f32  _retval = { dst, pred_dst_q };
	return _retval;
}


uint32_t execute_shf_l_clamp_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t n;
	uint32_t tmp_dst;
	uint32_t dst;

        n = MIN(src3, 32U);
	tmp_dst = (SHL(src2, n) | SHR(src1, (32U - n)));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shf_l_wrap_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t n;
	uint32_t tmp_dst;
	uint32_t dst;

        n = (src3 & 31U);
	tmp_dst = (SHL(src2, n) | SHR(src1, (32U - n)));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shf_r_clamp_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t n;
	uint32_t tmp_dst;
	uint32_t dst;

        n = MIN(src3, 32U);
	tmp_dst = (SHL(src2, (32U - n)) | SHR(src1, n));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shf_r_wrap_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint32_t n;
	uint32_t tmp_dst;
	uint32_t dst;

        n = (src3 & 31U);
	tmp_dst = (SHL(src2, (32U - n)) | SHR(src1, n));
	dst = tmp_dst;
	return dst;
}


uint16_t execute_shl_b16 (uint16_t src1, uint32_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = SHL(src1, MIN(src2, 16U));
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shl_b32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = SHL(src1, MIN(src2, 32U));
	dst = tmp_dst;
	return dst;
}


uint64_t execute_shl_b64 (uint64_t src1, uint32_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = SHL(src1, MIN(src2, 64U));
	dst = tmp_dst;
	return dst;
}


uint16_t execute_shr_b16 (uint16_t src1, uint32_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        src2 = MIN(src2, 16U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shr_b32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        src2 = MIN(src2, 32U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_shr_b64 (uint64_t src1, uint32_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        src2 = MIN(src2, 64U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


int16_t execute_shr_s16 (int16_t src1, uint32_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        src2 = MIN(src2, 16U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_shr_s64 (int64_t src1, uint32_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        src2 = MIN(src2, 64U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_shr_u16 (uint16_t src1, uint32_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        src2 = MIN(src2, 16U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_shr_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        src2 = MIN(src2, 32U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_shr_u64 (uint64_t src1, uint32_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        src2 = MIN(src2, 64U);
	tmp_dst = SHR(src1, src2);
	dst = tmp_dst;
	return dst;
}


float execute_sin_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = SINE(src1);
	dst = tmp_dst;
	return dst;
}


float execute_sin_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = SINE(src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_slct_b16_f32 (uint16_t src1, uint16_t src2, float src3) {
        float tmp;
	uint16_t tmp_dst;
	uint16_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint16_t execute_slct_b16_s32 (uint16_t src1, uint16_t src2, int32_t src3) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_b32_f32 (uint32_t src1, uint32_t src2, float src3) {
        float tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_b32_s32 (uint32_t src1, uint32_t src2, int32_t src3) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_b64_f32 (uint64_t src1, uint64_t src2, float src3) {
        float tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_b64_s32 (uint64_t src1, uint64_t src2, int32_t src3) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


float execute_slct_f32_f32 (float src1, float src2, float src3) {
        float tmp;
	float tmp_dst;
	float dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


float execute_slct_f32_s32 (float src1, float src2, int32_t src3) {
        float tmp_dst;
	float dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


double execute_slct_f64_f32 (double src1, double src2, float src3) {
        float tmp;
	double tmp_dst;
	double dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


double execute_slct_f64_s32 (double src1, double src2, int32_t src3) {
        double tmp_dst;
	double dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_slct_ftz_b16_f32 (uint16_t src1, uint16_t src2, float src3) {
        float tmp;
	uint16_t tmp_dst;
	uint16_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_ftz_b32_f32 (uint32_t src1, uint32_t src2, float src3) {
        float tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_ftz_b64_f32 (uint64_t src1, uint64_t src2, float src3) {
        float tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


float execute_slct_ftz_f32_f32 (float src1, float src2, float src3) {
        float tmp;
	float tmp_dst;
	float dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


double execute_slct_ftz_f64_f32 (double src1, double src2, float src3) {
        float tmp;
	double tmp_dst;
	double dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


int16_t execute_slct_ftz_s16_f32 (int16_t src1, int16_t src2, float src3) {
        float tmp;
	int16_t tmp_dst;
	int16_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


int32_t execute_slct_ftz_s32_f32 (int32_t src1, int32_t src2, float src3) {
        float tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


int64_t execute_slct_ftz_s64_f32 (int64_t src1, int64_t src2, float src3) {
        float tmp;
	int64_t tmp_dst;
	int64_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint16_t execute_slct_ftz_u16_f32 (uint16_t src1, uint16_t src2, float src3) {
        float tmp;
	uint16_t tmp_dst;
	uint16_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_ftz_u32_f32 (uint32_t src1, uint32_t src2, float src3) {
        float tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_ftz_u64_f32 (uint64_t src1, uint64_t src2, float src3) {
        float tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        tmp = FTZ(src3);
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


int16_t execute_slct_s16_s32 (int16_t src1, int16_t src2, int32_t src3) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_slct_s32_f32 (int32_t src1, int32_t src2, float src3) {
        float tmp;
	int32_t tmp_dst;
	int32_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


int32_t execute_slct_s32_s32 (int32_t src1, int32_t src2, int32_t src3) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_slct_s64_s32 (int64_t src1, int64_t src2, int32_t src3) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_slct_u16_s32 (uint16_t src1, uint16_t src2, int32_t src3) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_u32_f32 (uint32_t src1, uint32_t src2, float src3) {
        float tmp;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_slct_u32_s32 (uint32_t src1, uint32_t src2, int32_t src3) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_u64_f32 (uint64_t src1, uint64_t src2, float src3) {
        float tmp;
	uint64_t tmp_dst;
	uint64_t dst;

        tmp = src3;
	if (isnan(tmp)) {
		tmp_dst = src2;
	} else {
		tmp_dst = ((tmp >= 0) ? src1 : src2);
	};
	dst = tmp_dst;
	return dst;
}


uint64_t execute_slct_u64_s32 (uint64_t src1, uint64_t src2, int32_t src3) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = ((src3 >= 0) ? src1 : src2);
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_approx_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT(src1);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rm_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_DOWNWARD);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_sqrt_rm_f64 (double src1) {
        double tmp_dst;
	double dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_DOWNWARD);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rm_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_DOWNWARD);
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rn_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TONEAREST);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_sqrt_rn_f64 (double src1) {
        double tmp_dst;
	double dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TONEAREST);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rn_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TONEAREST);
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rp_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_UPWARD);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_sqrt_rp_f64 (double src1) {
        double tmp_dst;
	double dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_UPWARD);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rz_f32 (float src1) {
        float tmp_dst;
	float dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TOWARDZERO);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


double execute_sqrt_rz_f64 (double src1) {
        double tmp_dst;
	double dst;

        if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TOWARDZERO);
	};
	};
	};
	};
	dst = tmp_dst;
	return dst;
}


float execute_sqrt_rz_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if (((src1 < 0) && (!(fpclassify(src1) == FP_SUBNORMAL)))) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		tmp_dst = SQRT_ROUND(src1, FE_TOWARDZERO);
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_sub_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg) {
        struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_subc_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg) {
        struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_subc_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg) {
        struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_sub_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg) {
        struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_sub_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg) {
        struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_sub_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg) {
        struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp_dst = SUB_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


float execute_sub_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


double execute_sub_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


float execute_sub_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = (src1 - src2);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE((src1 - src2));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rm_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


double execute_sub_rm_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rm_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SUB_ROUND(src1, src2, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rm_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_DOWNWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rm_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_DOWNWARD));
	dst = tmp_dst;
	return dst;
}


float execute_sub_rn_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


double execute_sub_rn_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_TONEAREST);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rn_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SUB_ROUND(src1, src2, FE_TONEAREST);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rn_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_TONEAREST));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rn_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_TONEAREST));
	dst = tmp_dst;
	return dst;
}


float execute_sub_rp_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


double execute_sub_rp_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_UPWARD);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rp_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SUB_ROUND(src1, src2, FE_UPWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rp_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_UPWARD));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rp_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_UPWARD));
	dst = tmp_dst;
	return dst;
}


float execute_sub_rz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


double execute_sub_rz_f64 (double src1, double src2) {
        double tmp_dst;
	double dst;

        tmp_dst = SUB_ROUND(src1, src2, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rz_ftz_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SUB_ROUND(src1, src2, FE_TOWARDZERO);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rz_ftz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_TOWARDZERO));
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_sub_rz_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(SUB_ROUND(src1, src2, FE_TOWARDZERO));
	dst = tmp_dst;
	return dst;
}


int16_t execute_sub_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_sub_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_sub_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


float execute_sub_sat_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE((src1 - src2));
	dst = tmp_dst;
	return dst;
}


int32_t execute_sub_sat_s32 (int32_t src1, int32_t src2) {
        int32_t tmp_dst;
	int32_t dst;

        tmp_dst = SUB_SATURATE_s32(src1, src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_sub_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_sub_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = (src1 - src2);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_finite_f32 (float src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((isnan(src1) || (isinf(src1) == 1) || (isinf(src1) == -1)) ? 0 : 1);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_finite_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((isnan(src1) || (isinf(src1) == 1) || (isinf(src1) == -1)) ? 0 : 1);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_infinite_f32 (float src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (((isinf(src1) == -1) || (isinf(src1) == 1)) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_infinite_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (((isinf(src1) == -1) || (isinf(src1) == 1)) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_normal_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (((!isnan(src1)) && !(isinf(src1) == 1) && !(isinf(src1) == -1) && (!(fpclassify(src1) == FP_SUBNORMAL))) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_notanumber_f32 (float src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (isnan(src1) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_notanumber_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (isnan(src1) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_number_f32 (float src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((!isnan(src1)) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_number_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((!isnan(src1)) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_subnormal_f32 (float src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((fpclassify(src1) == FP_SUBNORMAL) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_testp_subnormal_f64 (double src1) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = ((fpclassify(src1) == FP_SUBNORMAL) ? 1 : 0);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_xor_b16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = (src1 ^ src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_xor_b32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        tmp_dst = (src1 ^ src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_xor_b64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = (src1 ^ src2);
	dst = tmp_dst;
	return dst;
}


unsigned int execute_xor_pred (unsigned int src1, unsigned int src2) {
        unsigned int tmp_dst;
	unsigned int dst;

        tmp_dst = (src1 ^ src2);
	dst = tmp_dst;
	return dst;
}


int32_t execute_add_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg) {
        struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, 0);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_addc_s32 (int32_t src1, int32_t src2, struct cc_register cc_reg) {
        struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_addc_s64 (int64_t src1, int64_t src2, struct cc_register cc_reg) {
        struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_addc_u64 (uint64_t src1, uint64_t src2, struct cc_register cc_reg) {
        struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp_dst = ADD_CARRY_STRUCT(src1, src2, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_add_s64 (int64_t src1, int64_t src2) {
        int64_t tmp_dst;
	int64_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_add_u64 (uint64_t src1, uint64_t src2) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = (src1 + src2);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_clz_b64 (uint64_t src2) {
        uint32_t tmp_dst;
	uint64_t tmp_src;
	uint32_t dst;

        tmp_dst = 0U;
	;;
	tmp_src = src2;
	while(((tmp_dst < 64U) && ((tmp_src & 9223372036854775808UL) == 0UL))) {
		tmp_dst = (tmp_dst + 1U);
		tmp_src = (tmp_src << 1UL);
};
	dst = tmp_dst;
	return dst;
}


float execute_cos_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = COSINE(src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_div_rm_f32 (float src1, float src2) {
        float tmp_dst;
	float dst;

        tmp_dst = DIV_ROUND(src1, src2, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


float execute_fma_rp_sat_f32 (float src1, float src2, float src3) {
        float tmp_dst;
	float dst;

        tmp_dst = SATURATE(FMA_ROUND(src1, src2, src3, FE_UPWARD));
	dst = tmp_dst;
	return dst;
}


float execute_lg2_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = INFINITY;
	} else {
		if (((src1 == 0.0) || (fpclassify(src1) == FP_ZERO && signbit(src1)))) {
		tmp_dst = -INFINITY;
	} else {
		if ((src1 < 0)) {
		tmp_dst = NAN;
	} else {
		tmp_dst = LOG2(src1);
	};
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_madc_hi_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32L);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_madc_hi_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_madc_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 32UL);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_madc_hi_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_madc_lo_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg->cf);
	cc_reg->cf = tmp_dst.overflow;
	dst = tmp_dst.value;
	return dst;
}


int32_t execute_madc_lo_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register cc_reg) {
        int64_t tmp;
	int32_t tmp_mul;
	struct value_carry_s32 tmp_dst;
	int32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((int32_t) ((uint32_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


int64_t execute_madc_lo_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register cc_reg) {
        my_int128_t tmp;
	int64_t tmp_mul;
	struct value_carry_s64 tmp_dst;
	int64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((int64_t) ((uint64_t) tmp));
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint32_t execute_madc_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register cc_reg) {
        uint64_t tmp;
	uint32_t tmp_mul;
	struct value_carry_u32 tmp_dst;
	uint32_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint32_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_madc_lo_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register cc_reg) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	struct value_carry_u64 tmp_dst;
	uint64_t dst;

        tmp = MULWIDE(src1, src2);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = ADD_CARRY_STRUCT(tmp_mul, src3, cc_reg.cf);
	dst = tmp_dst.value;
	return dst;
}


uint64_t execute_mad_hi_u64 (uint64_t src1, uint64_t src2, uint64_t src3) {
        my_uint128_t tmp;
	uint64_t tmp_mul;
	uint64_t tmp_dst;
	uint64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_mul = ((uint64_t) tmp);
	tmp_dst = (tmp_mul + src3);
	dst = tmp_dst;
	return dst;
}


double execute_mad_rm_f64 (double src1, double src2, double src3) {
        double tmp_dst;
	double dst;

        ;;
	tmp_dst = FMA_ROUND(src1, src2, src3, FE_DOWNWARD);
	dst = tmp_dst;
	return dst;
}


uint16_t execute_min_u16 (uint16_t src1, uint16_t src2) {
        uint16_t tmp_dst;
	uint16_t dst;

        tmp_dst = MIN(src1, src2);
	dst = tmp_dst;
	return dst;
}


int64_t execute_mul_hi_s64 (int64_t src1, int64_t src2) {
        my_int128_t tmp;
	int64_t tmp_dst;
	int64_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp = (tmp >> 64);
	tmp_dst = ((int64_t) ((uint64_t) tmp));
	dst = tmp_dst;
	return dst;
}


uint16_t execute_mul_lo_u16 (uint16_t src1, uint16_t src2) {
        uint32_t tmp;
	uint16_t tmp_dst;
	uint16_t dst;

        ;;
	tmp = MULWIDE(src1, src2);
	tmp_dst = ((uint16_t) tmp);
	dst = tmp_dst;
	return dst;
}


uint64_t execute_not_b64 (uint64_t src1) {
        uint64_t tmp_dst;
	uint64_t dst;

        tmp_dst = ~(src1);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_prmt_f4e_b32 (uint32_t src1, uint32_t src2, uint32_t src3) {
        uint64_t tmp64;
	uint32_t ctl_0;
	uint32_t ctl_1;
	uint32_t ctl_2;
	uint32_t ctl_3;
	uint32_t tmp_byte_0;
	uint32_t tmp_byte_1;
	uint32_t tmp_byte_2;
	uint32_t tmp_byte_3;
	uint32_t tmp_dst;
	uint32_t dst;

        tmp64 = ((((uint64_t) src2) << 32UL) | ((uint64_t) src1));
	ctl_0 = 0U;
	ctl_1 = 0U;
	ctl_2 = 0U;
	ctl_3 = 0U;
	ctl_0 = (SHR(src3, 0U) & 3U);
	ctl_1 = (SHR(src3, 0U) & 3U);
	ctl_2 = (SHR(src3, 0U) & 3U);
	ctl_3 = (SHR(src3, 0U) & 3U);
	tmp_byte_0 = ReadByte_f4e(ctl_0, tmp64, 0U);
	tmp_byte_1 = ReadByte_f4e(ctl_1, tmp64, 1U);
	tmp_byte_2 = ReadByte_f4e(ctl_2, tmp64, 2U);
	tmp_byte_3 = ReadByte_f4e(ctl_3, tmp64, 3U);
	tmp_dst = (((SHL(tmp_byte_3, 24U) | SHL(tmp_byte_2, 16U)) | SHL(tmp_byte_1, 8U)) | tmp_byte_0);
	dst = tmp_dst;
	return dst;
}


double execute_rcp_approx_ftz_f64 (double src1) {
        double tmp_dst;
	double dst;

        src1 = FTZ(src1);
	tmp_dst = RCP(src1);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rm_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	tmp_dst = RCP_ROUND(src1, FE_DOWNWARD);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_rcp_rz_f32 (float src1) {
        float tmp_dst;
	float dst;

        tmp_dst = RCP_ROUND(src1, FE_TOWARDZERO);
	dst = tmp_dst;
	return dst;
}


int16_t execute_rem_s16 (int16_t src1, int16_t src2) {
        int16_t tmp_dst;
	int16_t dst;

        if ((src2 == 0)) {
		tmp_dst = -1;
	} else {
		if ((src2 < 0)) {
		tmp_dst = MACHINE_SPECIFIC_execute_rem_divide_by_neg(src1, src2);
	} else {
		tmp_dst = (src1 % src2);
	};
	};
	dst = tmp_dst;
	return dst;
}


uint32_t execute_rem_u32 (uint32_t src1, uint32_t src2) {
        uint32_t tmp_dst;
	uint32_t dst;

        if ((src2 == 0U)) {
		tmp_dst = (src1);
	} else {
		tmp_dst = (src1 % src2);
	};
	dst = tmp_dst;
	return dst;
}


float execute_rsqrt_approx_ftz_f32 (float src1) {
        float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	if ((fpclassify(src1) == FP_ZERO && signbit(src1))) {
		tmp_dst = -INFINITY;
	} else {
		if ((src1 == 0.0)) {
		tmp_dst = INFINITY;
	} else {
		if ((isinf(src1) == -1)) {
		tmp_dst = NAN;
	} else {
		if ((isinf(src1) == 1)) {
		tmp_dst = 0.0;
	} else {
		if (isnan(src1)) {
		tmp_dst = NAN;
	} else {
		if ((src1 < 0)) {
		tmp_dst = NAN;
	} else {
		tmp_dst = RSQRT(src1);
	};
	};
	};
	};
	};
	};
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_b32 (uint32_t src1, uint32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_f32_s32 (int32_t src1, int32_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_f32 (float src1, float src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_and_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_and_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_or_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_or_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_u32_f64 (double src1, double src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_equ_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_equ_xor_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_equ_xor_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_eq_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_eq_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_eq_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 == src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_f32_u16 (uint16_t src1, uint16_t src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_s32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_u32_s64 (int64_t src1, int64_t src2) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = (pred2 ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_and_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_and_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_or_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_or_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_geu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_geu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_geu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = isnan(src1) || isnan(src2) || (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_ge_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 >= src2);
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && (!pred_reg)) || (pred2 && (!(!pred_reg)))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_ge_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_ge_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 >= src2);
	;;
	tmp_dst = ((((!pred2) && pred_reg) || (pred2 && (!pred_reg))) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 && (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && (!pred_reg)) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 && pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_f32_f64 (double src1, double src2) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = (pred2 ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || pred_reg) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        pred2 = (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	dst = tmp_dst;
	return dst;
}


float execute_set_gt_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	float tmp_dst;
	float dst;

        src1 = FTZ(src1);
	src2 = FTZ(src2);
	pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	tmp_dst = ((pred2 || (!pred_reg)) ? 1.0 : 0.0);
	tmp_dst = FTZ(tmp_dst);
	dst = tmp_dst;
	return dst;
}


uint32_t execute_set_gt_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	uint32_t tmp_dst;
	uint32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || (!pred_reg)) ? 4294967295U : 0U);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_s32_f32 (float src1, float src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_s32_f64 (double src1, double src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (!(isnan(src1) || isnan(src2))) && (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg) {
        unsigned int pred2;
	int32_t tmp_dst;
	int32_t dst;

        pred2 = (src1 > src2);
	;;
	tmp_dst = ((pred2 || pred_reg) ? 4294967295 : 0);
	dst = tmp_dst;
	return dst;
}


int32_t execute_set_gt_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg)