#include <stdlib.h>

#include <stdint.h>

#include <math.h>

struct cc_register { int cf;};

typedef const char * RM;
struct value_carry_u32 {
    uint32_t value;
    int overflow;
};
struct value_carry_s32 {
    int32_t value;
    int overflow;
};
struct value_carry_s64 {
    int64_t value;
    int overflow;
};
struct value_carry_u64 {
    uint64_t value;
    int overflow;
};
float execute_abs_f32 (float src1);
void execute_ret ();
double execute_abs_f64 (double src1);
float execute_abs_ftz_f32 (float src1);
int16_t execute_abs_s16 (int16_t src1);
int32_t execute_abs_s32 (int32_t src1);
int64_t execute_abs_s64 (int64_t src1);
uint32_t execute_add_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg);
int32_t execute_addc_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg);
uint32_t execute_addc_u32 (uint32_t src1, uint32_t src2, struct cc_register cc_reg);
int64_t execute_addc_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg);
uint32_t execute_addc_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg);
uint64_t execute_addc_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg);
int64_t execute_add_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg);
uint64_t execute_add_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg);
float execute_add_f32 (float src1, float src2);
double execute_add_f64 (double src1, double src2);
float execute_add_ftz_f32 (float src1, float src2);
float execute_add_ftz_sat_f32 (float src1, float src2);
float execute_add_rm_f32 (float src1, float src2);
double execute_add_rm_f64 (double src1, double src2);
float execute_add_rm_ftz_f32 (float src1, float src2);
float execute_add_rm_ftz_sat_f32 (float src1, float src2);
float execute_add_rm_sat_f32 (float src1, float src2);
float execute_add_rn_f32 (float src1, float src2);
double execute_add_rn_f64 (double src1, double src2);
float execute_add_rn_ftz_f32 (float src1, float src2);
float execute_add_rn_ftz_sat_f32 (float src1, float src2);
float execute_add_rn_sat_f32 (float src1, float src2);
float execute_add_rp_f32 (float src1, float src2);
double execute_add_rp_f64 (double src1, double src2);
float execute_add_rp_ftz_f32 (float src1, float src2);
float execute_add_rp_ftz_sat_f32 (float src1, float src2);
float execute_add_rp_sat_f32 (float src1, float src2);
float execute_add_rz_f32 (float src1, float src2);
double execute_add_rz_f64 (double src1, double src2);
float execute_add_rz_ftz_f32 (float src1, float src2);
float execute_add_rz_ftz_sat_f32 (float src1, float src2);
float execute_add_rz_sat_f32 (float src1, float src2);
int16_t execute_add_s16 (int16_t src1, int16_t src2);
int32_t execute_add_s32 (int32_t src1, int32_t src2);
float execute_add_sat_f32 (float src1, float src2);
int32_t execute_add_sat_s32 (int32_t src1, int32_t src2);
uint16_t execute_add_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_add_u32 (uint32_t src1, uint32_t src2);
uint16_t execute_and_b16 (uint16_t src1, uint16_t src2);
unsigned int execute_and_pred (unsigned int src1, unsigned int src2);
uint32_t execute_and_b32 (uint32_t src1, uint32_t src2);
uint64_t execute_and_b64 (uint64_t src1, uint64_t src2);
uint32_t execute_bfind_s32 (int32_t src2);
uint32_t execute_bfind_s64 (int64_t src2);
uint32_t execute_bfind_shiftamt_s32 (int32_t src2);
uint32_t execute_bfind_shiftamt_s64 (int64_t src2);
uint32_t execute_bfind_shiftamt_u32 (uint32_t src2);
uint32_t execute_bfind_shiftamt_u64 (uint64_t src2);
uint32_t execute_bfind_u32 (uint32_t src2);
uint32_t execute_bfind_u64 (uint64_t src2);
uint32_t execute_clz_b32 (uint32_t src2);
uint16_t execute_cnot_b16 (uint16_t src1);
uint32_t execute_cnot_b32 (uint32_t src1);
uint64_t execute_cnot_b64 (uint64_t src1);
float execute_copysign_f32 (float src1, float src2);
double execute_copysign_f64 (double src1, double src2);
float execute_cos_approx_f32 (float src1);
float execute_div_approx_f32 (float src1, float src2);
float execute_div_approx_ftz_f32 (float src1, float src2);
float execute_div_full_f32 (float src1, float src2);
float execute_div_full_ftz_f32 (float src1, float src2);
double execute_div_rm_f64 (double src1, double src2);
float execute_div_rm_ftz_f32 (float src1, float src2);
float execute_div_rn_f32 (float src1, float src2);
double execute_div_rn_f64 (double src1, double src2);
float execute_div_rn_ftz_f32 (float src1, float src2);
float execute_div_rp_f32 (float src1, float src2);
double execute_div_rp_f64 (double src1, double src2);
float execute_div_rp_ftz_f32 (float src1, float src2);
float execute_div_rz_f32 (float src1, float src2);
double execute_div_rz_f64 (double src1, double src2);
float execute_div_rz_ftz_f32 (float src1, float src2);
int16_t execute_div_s16 (int16_t src1, int16_t src2);
int32_t execute_div_s32 (int32_t src1, int32_t src2);
int64_t execute_div_s64 (int64_t src1, int64_t src2);
uint16_t execute_div_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_div_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_div_u64 (uint64_t src1, uint64_t src2);
int32_t execute_dp4a_s32_s32 (uint32_t src1, uint32_t src2, uint32_t src3);
int32_t execute_dp4a_s32_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
int32_t execute_dp4a_u32_s32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_dp4a_u32_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
float execute_ex2_approx_f32 (float src1);
float execute_ex2_approx_ftz_f32 (float src1);
float execute_fma_rm_f32 (float src1, float src2, float src3);
double execute_fma_rm_f64 (double src1, double src2, double src3);
float execute_fma_rm_ftz_f32 (float src1, float src2, float src3);
float execute_fma_rm_ftz_sat_f32 (float src1, float src2, float src3);
float execute_fma_rm_sat_f32 (float src1, float src2, float src3);
float execute_fma_rn_f32 (float src1, float src2, float src3);
double execute_fma_rn_f64 (double src1, double src2, double src3);
float execute_fma_rn_ftz_f32 (float src1, float src2, float src3);
float execute_fma_rn_ftz_sat_f32 (float src1, float src2, float src3);
float execute_fma_rn_sat_f32 (float src1, float src2, float src3);
float execute_fma_rp_f32 (float src1, float src2, float src3);
double execute_fma_rp_f64 (double src1, double src2, double src3);
float execute_fma_rp_ftz_f32 (float src1, float src2, float src3);
float execute_fma_rp_ftz_sat_f32 (float src1, float src2, float src3);
float execute_fma_rz_f32 (float src1, float src2, float src3);
double execute_fma_rz_f64 (double src1, double src2, double src3);
float execute_fma_rz_ftz_f32 (float src1, float src2, float src3);
float execute_fma_rz_ftz_sat_f32 (float src1, float src2, float src3);
float execute_fma_rz_sat_f32 (float src1, float src2, float src3);
uint32_t execute_fns_b32 (uint32_t src1, uint32_t src2, int32_t src3);
float execute_lg2_approx_f32 (float src1);
uint32_t execute_lop3_b32 (uint32_t src1, uint32_t src2, uint32_t src3, uint8_t immLut);
int32_t execute_mad24_hi_s32 (int32_t src1, int32_t src2, int32_t src3);
int32_t execute_mad24_hi_sat_s32 (int32_t src1, int32_t src2, int32_t src3);
uint32_t execute_mad24_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
int32_t execute_mad24_lo_s32 (int32_t src1, int32_t src2, int32_t src3);
uint32_t execute_mad24_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
int32_t execute_madc_hi_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg);
int64_t execute_madc_hi_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg);
uint32_t execute_madc_hi_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg);
uint64_t execute_madc_hi_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg);
int32_t execute_madc_lo_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg);
int64_t execute_madc_lo_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg);
uint32_t execute_madc_lo_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg);
int32_t execute_mad_hi_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg);
int64_t execute_mad_hi_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg);
uint32_t execute_mad_hi_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg);
uint64_t execute_mad_hi_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg);
int16_t execute_mad_hi_s16 (int16_t src1, int16_t src2, int16_t src3);
int32_t execute_mad_hi_s32 (int32_t src1, int32_t src2, int32_t src3);
int64_t execute_mad_hi_s64 (int64_t src1, int64_t src2, int64_t src3);
int32_t execute_mad_hi_sat_s32 (int32_t src1, int32_t src2, int32_t src3);
uint16_t execute_mad_hi_u16 (uint16_t src1, uint16_t src2, uint16_t src3);
uint32_t execute_mad_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
int32_t execute_mad_lo_cc_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register * cc_reg);
int64_t execute_mad_lo_cc_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register * cc_reg);
uint32_t execute_mad_lo_cc_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register * cc_reg);
uint64_t execute_mad_lo_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg);
int16_t execute_mad_lo_s16 (int16_t src1, int16_t src2, int16_t src3);
int32_t execute_mad_lo_s32 (int32_t src1, int32_t src2, int32_t src3);
int64_t execute_mad_lo_s64 (int64_t src1, int64_t src2, int64_t src3);
uint16_t execute_mad_lo_u16 (uint16_t src1, uint16_t src2, uint16_t src3);
uint32_t execute_mad_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint64_t execute_mad_lo_u64 (uint64_t src1, uint64_t src2, uint64_t src3);
float execute_mad_rm_f32 (float src1, float src2, float src3);
float execute_mad_rm_ftz_f32 (float src1, float src2, float src3);
float execute_mad_rm_ftz_sat_f32 (float src1, float src2, float src3);
float execute_mad_rm_sat_f32 (float src1, float src2, float src3);
float execute_mad_rn_f32 (float src1, float src2, float src3);
double execute_mad_rn_f64 (double src1, double src2, double src3);
float execute_mad_rn_ftz_f32 (float src1, float src2, float src3);
float execute_mad_rn_ftz_sat_f32 (float src1, float src2, float src3);
float execute_mad_rn_sat_f32 (float src1, float src2, float src3);
float execute_mad_rp_f32 (float src1, float src2, float src3);
double execute_mad_rp_f64 (double src1, double src2, double src3);
float execute_mad_rp_ftz_f32 (float src1, float src2, float src3);
float execute_mad_rp_ftz_sat_f32 (float src1, float src2, float src3);
float execute_mad_rp_sat_f32 (float src1, float src2, float src3);
float execute_mad_rz_f32 (float src1, float src2, float src3);
double execute_mad_rz_f64 (double src1, double src2, double src3);
float execute_mad_rz_ftz_f32 (float src1, float src2, float src3);
float execute_mad_rz_ftz_sat_f32 (float src1, float src2, float src3);
float execute_mad_rz_sat_f32 (float src1, float src2, float src3);
int32_t execute_mad_wide_s16 (int16_t src1, int16_t src2, int32_t src3);
int64_t execute_mad_wide_s32 (int32_t src1, int32_t src2, int64_t src3);
uint32_t execute_mad_wide_u16 (uint16_t src1, uint16_t src2, uint32_t src3);
uint64_t execute_mad_wide_u32 (uint32_t src1, uint32_t src2, uint64_t src3);
float execute_max_f32 (float src1, float src2);
double execute_max_f64 (double src1, double src2);
float execute_max_ftz_f32 (float src1, float src2);
int16_t execute_max_s16 (int16_t src1, int16_t src2);
int32_t execute_max_s32 (int32_t src1, int32_t src2);
int64_t execute_max_s64 (int64_t src1, int64_t src2);
uint16_t execute_max_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_max_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_max_u64 (uint64_t src1, uint64_t src2);
float execute_min_f32 (float src1, float src2);
double execute_min_f64 (double src1, double src2);
float execute_min_ftz_f32 (float src1, float src2);
int16_t execute_min_s16 (int16_t src1, int16_t src2);
int32_t execute_min_s32 (int32_t src1, int32_t src2);
int64_t execute_min_s64 (int64_t src1, int64_t src2);
uint32_t execute_min_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_min_u64 (uint64_t src1, uint64_t src2);
uint16_t execute_mov_b16 (uint16_t src1);
uint32_t execute_mov_b32 (uint32_t src1);
uint64_t execute_mov_b64 (uint64_t src1);
float execute_mov_f32 (float src1);
double execute_mov_f64 (double src1);
int16_t execute_mov_s16 (int16_t src1);
int32_t execute_mov_s32 (int32_t src1);
int64_t execute_mov_s64 (int64_t src1);
uint16_t execute_mov_u16 (uint16_t src1);
uint32_t execute_mov_u32 (uint32_t src1);
uint64_t execute_mov_u64 (uint64_t src1);
int32_t execute_mul24_hi_s32 (int32_t src1, int32_t src2);
uint32_t execute_mul24_hi_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_mul24_lo_u32 (uint32_t src1, uint32_t src2);
float execute_mul_f32 (float src1, float src2);
double execute_mul_f64 (double src1, double src2);
float execute_mul_ftz_f32 (float src1, float src2);
float execute_mul_ftz_sat_f32 (float src1, float src2);
int16_t execute_mul_hi_s16 (int16_t src1, int16_t src2);
int32_t execute_mul_hi_s32 (int32_t src1, int32_t src2);
uint16_t execute_mul_hi_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_mul_hi_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_mul_hi_u64 (uint64_t src1, uint64_t src2);
int16_t execute_mul_lo_s16 (int16_t src1, int16_t src2);
int32_t execute_mul_lo_s32 (int32_t src1, int32_t src2);
int64_t execute_mul_lo_s64 (int64_t src1, int64_t src2);
uint32_t execute_mul_lo_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_mul_lo_u64 (uint64_t src1, uint64_t src2);
float execute_mul_rm_f32 (float src1, float src2);
double execute_mul_rm_f64 (double src1, double src2);
float execute_mul_rm_ftz_f32 (float src1, float src2);
float execute_mul_rm_ftz_sat_f32 (float src1, float src2);
float execute_mul_rm_sat_f32 (float src1, float src2);
float execute_mul_rn_f32 (float src1, float src2);
double execute_mul_rn_f64 (double src1, double src2);
float execute_mul_rn_ftz_f32 (float src1, float src2);
float execute_mul_rn_ftz_sat_f32 (float src1, float src2);
float execute_mul_rn_sat_f32 (float src1, float src2);
float execute_mul_rp_f32 (float src1, float src2);
double execute_mul_rp_f64 (double src1, double src2);
float execute_mul_rp_ftz_f32 (float src1, float src2);
float execute_mul_rp_ftz_sat_f32 (float src1, float src2);
float execute_mul_rp_sat_f32 (float src1, float src2);
float execute_mul_rz_f32 (float src1, float src2);
double execute_mul_rz_f64 (double src1, double src2);
float execute_mul_rz_ftz_f32 (float src1, float src2);
float execute_mul_rz_ftz_sat_f32 (float src1, float src2);
float execute_mul_rz_sat_f32 (float src1, float src2);
float execute_mul_sat_f32 (float src1, float src2);
int32_t execute_mul_wide_s16 (int16_t src1, int16_t src2);
int64_t execute_mul_wide_s32 (int32_t src1, int32_t src2);
uint32_t execute_mul_wide_u16 (uint16_t src1, uint16_t src2);
uint64_t execute_mul_wide_u32 (uint32_t src1, uint32_t src2);
float execute_neg_f32 (float src1);
double execute_neg_f64 (double src1);
float execute_neg_ftz_f32 (float src1);
int16_t execute_neg_s16 (int16_t src1);
int32_t execute_neg_s32 (int32_t src1);
int64_t execute_neg_s64 (int64_t src1);
uint16_t execute_not_b16 (uint16_t src1);
unsigned int execute_not_pred (unsigned int src1);
uint32_t execute_not_b32 (uint32_t src1);
unsigned int execute_or_pred (unsigned int src1, unsigned int src2);
uint16_t execute_or_b16 (uint16_t src1, uint16_t src2);
uint32_t execute_or_b32 (uint32_t src1, uint32_t src2);
uint64_t execute_or_b64 (uint64_t src1, uint64_t src2);
uint32_t execute_popc_b32 (uint32_t src2);
uint32_t execute_popc_b64 (uint64_t src2);
uint32_t execute_prmt_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_prmt_b4e_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_prmt_ecl_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_prmt_ecr_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_prmt_rc16_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_prmt_rc8_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
float execute_rcp_approx_f32 (float src1);
float execute_rcp_approx_ftz_f32 (float src1);
float execute_rcp_rm_f32 (float src1);
double execute_rcp_rm_f64 (double src1);
float execute_rcp_rn_f32 (float src1);
double execute_rcp_rn_f64 (double src1);
float execute_rcp_rn_ftz_f32 (float src1);
float execute_rcp_rp_f32 (float src1);
double execute_rcp_rp_f64 (double src1);
float execute_rcp_rp_ftz_f32 (float src1);
double execute_rcp_rz_f64 (double src1);
float execute_rcp_rz_ftz_f32 (float src1);
int32_t execute_rem_s32 (int32_t src1, int32_t src2);
int64_t execute_rem_s64 (int64_t src1, int64_t src2);
uint16_t execute_rem_u16 (uint16_t src1, uint16_t src2);
uint64_t execute_rem_u64 (uint64_t src1, uint64_t src2);
float execute_rsqrt_approx_f32 (float src1);
double execute_rsqrt_approx_f64 (double src1);
int16_t execute_sad_s16 (int16_t src1, int16_t src2, int16_t src3);
int32_t execute_sad_s32 (int32_t src1, int32_t src2, int32_t src3);
int64_t execute_sad_s64 (int64_t src1, int64_t src2, int64_t src3);
uint16_t execute_sad_u16 (uint16_t src1, uint16_t src2, uint16_t src3);
uint32_t execute_sad_u32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint64_t execute_sad_u64 (uint64_t src1, uint64_t src2, uint64_t src3);
unsigned int execute_setp_eq_s32 (int32_t src1, int32_t src2);
unsigned int execute_mov_pred (unsigned int src1);
float execute_set_eq_and_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_f32_b16 (uint16_t src1, uint16_t src2);
float execute_set_eq_f32_b64 (uint64_t src1, uint64_t src2);
float execute_set_eq_f32_f32 (float src1, float src2);
float execute_set_eq_f32_f64 (double src1, double src2);
float execute_set_eq_f32_s16 (int16_t src1, int16_t src2);
float execute_set_eq_f32_s64 (int64_t src1, int64_t src2);
float execute_set_eq_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_eq_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_eq_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_eq_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_eq_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_eq_ftz_u32_f32 (float src1, float src2);
float execute_set_eq_or_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_s32_b16 (uint16_t src1, uint16_t src2);
int32_t execute_set_eq_s32_b32 (uint32_t src1, uint32_t src2);
int32_t execute_set_eq_s32_b64 (uint64_t src1, uint64_t src2);
int32_t execute_set_eq_s32_f32 (float src1, float src2);
int32_t execute_set_eq_s32_f64 (double src1, double src2);
int32_t execute_set_eq_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_eq_s32_s32 (int32_t src1, int32_t src2);
int32_t execute_set_eq_s32_s64 (int64_t src1, int64_t src2);
int32_t execute_set_eq_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_eq_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_eq_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_eq_u32_b16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_eq_u32_b32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_eq_u32_b64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_eq_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_eq_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_eq_u32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_eq_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_eq_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_eq_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_equ_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_f32_f32 (float src1, float src2);
float execute_set_equ_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_equ_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_equ_ftz_u32_f32 (float src1, float src2);
float execute_set_equ_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_equ_s32_f32 (float src1, float src2);
int32_t execute_set_equ_s32_f64 (double src1, double src2);
uint32_t execute_set_equ_u32_f32 (float src1, float src2);
float execute_set_equ_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ge_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_f32_f32 (float src1, float src2);
float execute_set_ge_f32_f64 (double src1, double src2);
float execute_set_ge_f32_s16 (int16_t src1, int16_t src2);
float execute_set_ge_f32_s32 (int32_t src1, int32_t src2);
float execute_set_ge_f32_s64 (int64_t src1, int64_t src2);
float execute_set_ge_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_ge_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_ge_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_ge_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_ge_ftz_u32_f32 (float src1, float src2);
float execute_set_ge_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_s32_f32 (float src1, float src2);
int32_t execute_set_ge_s32_f64 (double src1, double src2);
int32_t execute_set_ge_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_ge_s32_s32 (int32_t src1, int32_t src2);
int32_t execute_set_ge_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_ge_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_ge_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_ge_u32_f32 (float src1, float src2);
uint32_t execute_set_ge_u32_f64 (double src1, double src2);
uint32_t execute_set_ge_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_ge_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_ge_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_ge_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_ge_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_geu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_f32_f32 (float src1, float src2);
float execute_set_geu_f32_f64 (double src1, double src2);
float execute_set_geu_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_geu_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_geu_ftz_u32_f32 (float src1, float src2);
float execute_set_geu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_geu_s32_f32 (float src1, float src2);
int32_t execute_set_geu_s32_f64 (double src1, double src2);
uint32_t execute_set_geu_u32_f32 (float src1, float src2);
uint32_t execute_set_geu_u32_f64 (double src1, double src2);
float execute_set_geu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_f32_f32 (float src1, float src2);
float execute_set_gt_f32_s16 (int16_t src1, int16_t src2);
float execute_set_gt_f32_s32 (int32_t src1, int32_t src2);
float execute_set_gt_f32_s64 (int64_t src1, int64_t src2);
float execute_set_gt_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_gt_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_gt_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_gt_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_gt_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_gt_ftz_u32_f32 (float src1, float src2);
float execute_set_gt_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_s32_f32 (float src1, float src2);
int32_t execute_set_gt_s32_f64 (double src1, double src2);
int32_t execute_set_gt_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_gt_s32_s64 (int64_t src1, int64_t src2);
int32_t execute_set_gt_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_gt_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_gt_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_gt_u32_f32 (float src1, float src2);
uint32_t execute_set_gt_u32_f64 (double src1, double src2);
uint32_t execute_set_gt_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_gt_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_gt_u32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_gt_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_gt_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_gt_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_gtu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_f32_f64 (double src1, double src2);
float execute_set_gtu_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_gtu_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_gtu_ftz_u32_f32 (float src1, float src2);
float execute_set_gtu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gtu_s32_f32 (float src1, float src2);
int32_t execute_set_gtu_s32_f64 (double src1, double src2);
uint32_t execute_set_gtu_u32_f32 (float src1, float src2);
uint32_t execute_set_gtu_u32_f64 (double src1, double src2);
float execute_set_gtu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hi_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_hi_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_hi_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_hi_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_hi_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_hi_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_hi_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_hi_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_hi_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hs_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hs_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_hs_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_hs_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_hs_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_hs_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_hs_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_hs_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_hs_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_hs_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_hs_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_f32_f32 (float src1, float src2);
float execute_set_le_f32_f64 (double src1, double src2);
float execute_set_le_f32_s16 (int16_t src1, int16_t src2);
float execute_set_le_f32_s32 (int32_t src1, int32_t src2);
float execute_set_le_f32_s64 (int64_t src1, int64_t src2);
float execute_set_le_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_le_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_le_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_le_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_le_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_le_ftz_u32_f32 (float src1, float src2);
float execute_set_le_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_le_s32_f32 (float src1, float src2);
int32_t execute_set_le_s32_f64 (double src1, double src2);
int32_t execute_set_le_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_le_s32_s32 (int32_t src1, int32_t src2);
int32_t execute_set_le_s32_s64 (int64_t src1, int64_t src2);
int32_t execute_set_le_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_le_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_le_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_le_u32_f32 (float src1, float src2);
uint32_t execute_set_le_u32_f64 (double src1, double src2);
uint32_t execute_set_le_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_le_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_le_u32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_le_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_le_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_le_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_leu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_leu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_f32_f32 (float src1, float src2);
float execute_set_leu_f32_f64 (double src1, double src2);
float execute_set_leu_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_leu_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_leu_ftz_u32_f32 (float src1, float src2);
float execute_set_leu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_leu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_leu_s32_f32 (float src1, float src2);
int32_t execute_set_leu_s32_f64 (double src1, double src2);
uint32_t execute_set_leu_u32_f32 (float src1, float src2);
uint32_t execute_set_leu_u32_f64 (double src1, double src2);
float execute_set_leu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_leu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lo_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lo_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_lo_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_lo_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_lo_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lo_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_lo_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_lo_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_lo_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_lo_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_lo_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_lo_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lo_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ls_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ls_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_ls_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_ls_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_ls_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ls_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ls_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_ls_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_ls_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_ls_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_ls_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_ls_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_ls_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ls_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_f32_f32 (float src1, float src2);
float execute_set_lt_f32_f64 (double src1, double src2);
float execute_set_lt_f32_s16 (int16_t src1, int16_t src2);
float execute_set_lt_f32_s32 (int32_t src1, int32_t src2);
float execute_set_lt_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_lt_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_lt_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_lt_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_lt_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_lt_ftz_u32_f32 (float src1, float src2);
float execute_set_lt_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_s32_f32 (float src1, float src2);
int32_t execute_set_lt_s32_f64 (double src1, double src2);
int32_t execute_set_lt_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_lt_s32_s32 (int32_t src1, int32_t src2);
int32_t execute_set_lt_s32_s64 (int64_t src1, int64_t src2);
int32_t execute_set_lt_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_lt_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_lt_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_lt_u32_f32 (float src1, float src2);
uint32_t execute_set_lt_u32_f64 (double src1, double src2);
uint32_t execute_set_lt_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_lt_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_lt_u32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_lt_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_lt_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_lt_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_ltu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_f32_f32 (float src1, float src2);
float execute_set_ltu_f32_f64 (double src1, double src2);
float execute_set_ltu_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_ltu_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_ltu_ftz_u32_f32 (float src1, float src2);
float execute_set_ltu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ltu_s32_f32 (float src1, float src2);
int32_t execute_set_ltu_s32_f64 (double src1, double src2);
uint32_t execute_set_ltu_u32_f32 (float src1, float src2);
uint32_t execute_set_ltu_u32_f64 (double src1, double src2);
float execute_set_ltu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_nan_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_f32_f32 (float src1, float src2);
float execute_set_nan_f32_f64 (double src1, double src2);
float execute_set_nan_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_nan_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_nan_ftz_u32_f32 (float src1, float src2);
float execute_set_nan_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_nan_s32_f32 (float src1, float src2);
int32_t execute_set_nan_s32_f64 (double src1, double src2);
uint32_t execute_set_nan_u32_f32 (float src1, float src2);
uint32_t execute_set_nan_u32_f64 (double src1, double src2);
float execute_set_nan_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_f32_b16 (uint16_t src1, uint16_t src2);
float execute_set_ne_f32_b32 (uint32_t src1, uint32_t src2);
float execute_set_ne_f32_b64 (uint64_t src1, uint64_t src2);
float execute_set_ne_f32_f32 (float src1, float src2);
float execute_set_ne_f32_f64 (double src1, double src2);
float execute_set_ne_f32_s16 (int16_t src1, int16_t src2);
float execute_set_ne_f32_s64 (int64_t src1, int64_t src2);
float execute_set_ne_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_ne_f32_u32 (uint32_t src1, uint32_t src2);
float execute_set_ne_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_ne_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_ne_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_ne_ftz_u32_f32 (float src1, float src2);
float execute_set_ne_or_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_s32_b16 (uint16_t src1, uint16_t src2);
int32_t execute_set_ne_s32_b32 (uint32_t src1, uint32_t src2);
int32_t execute_set_ne_s32_b64 (uint64_t src1, uint64_t src2);
int32_t execute_set_ne_s32_f64 (double src1, double src2);
int32_t execute_set_ne_s32_s16 (int16_t src1, int16_t src2);
int32_t execute_set_ne_s32_s32 (int32_t src1, int32_t src2);
int32_t execute_set_ne_s32_s64 (int64_t src1, int64_t src2);
int32_t execute_set_ne_s32_u16 (uint16_t src1, uint16_t src2);
int32_t execute_set_ne_s32_u32 (uint32_t src1, uint32_t src2);
int32_t execute_set_ne_s32_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_ne_u32_b16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_ne_u32_b32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_ne_u32_b64 (uint64_t src1, uint64_t src2);
uint32_t execute_set_ne_u32_f32 (float src1, float src2);
uint32_t execute_set_ne_u32_f64 (double src1, double src2);
uint32_t execute_set_ne_u32_s16 (int16_t src1, int16_t src2);
uint32_t execute_set_ne_u32_s32 (int32_t src1, int32_t src2);
uint32_t execute_set_ne_u32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_ne_u32_u16 (uint16_t src1, uint16_t src2);
uint32_t execute_set_ne_u32_u32 (uint32_t src1, uint32_t src2);
uint32_t execute_set_ne_u32_u64 (uint64_t src1, uint64_t src2);
float execute_set_neu_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_f32_f32 (float src1, float src2);
float execute_set_neu_f32_f64 (double src1, double src2);
float execute_set_neu_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_neu_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_neu_ftz_u32_f32 (float src1, float src2);
float execute_set_neu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_neu_s32_f32 (float src1, float src2);
int32_t execute_set_neu_s32_f64 (double src1, double src2);
uint32_t execute_set_neu_u32_f32 (float src1, float src2);
uint32_t execute_set_neu_u32_f64 (double src1, double src2);
float execute_set_neu_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_num_and_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_f32_f32 (float src1, float src2);
float execute_set_num_f32_f64 (double src1, double src2);
float execute_set_num_ftz_f32_f32 (float src1, float src2);
int32_t execute_set_num_ftz_s32_f32 (float src1, float src2);
uint32_t execute_set_num_ftz_u32_f32 (float src1, float src2);
float execute_set_num_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_or_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_or_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_num_s32_f32 (float src1, float src2);
int32_t execute_set_num_s32_f64 (double src1, double src2);
uint32_t execute_set_num_u32_f32 (float src1, float src2);
uint32_t execute_set_num_u32_f64 (double src1, double src2);
float execute_set_num_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_xor_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_xor_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_b16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_eq_b32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_eq_b64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_eq_f64 (double src1, double src2);
unsigned int execute_setp_eq_ftz_f32 (float src1, float src2);
unsigned int execute_setp_eq_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_eq_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_eq_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_eq_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_eq_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_equ_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_equ_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_equ_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_f32 (float src1, float src2);
unsigned int execute_setp_equ_f64 (double src1, double src2);
unsigned int execute_setp_equ_ftz_f32 (float src1, float src2);
unsigned int execute_setp_equ_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_equ_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_equ_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_f32 (float src1, float src2);
unsigned int execute_setp_ge_f64 (double src1, double src2);
unsigned int execute_setp_ge_ftz_f32 (float src1, float src2);
unsigned int execute_setp_ge_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_ge_s32 (int32_t src1, int32_t src2);
unsigned int execute_setp_ge_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_ge_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_ge_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_geu_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_f32 (float src1, float src2);
unsigned int execute_setp_geu_f64 (double src1, double src2);
unsigned int execute_setp_geu_ftz_f32 (float src1, float src2);
unsigned int execute_setp_geu_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_geu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_f32 (float src1, float src2);
unsigned int execute_setp_gt_f64 (double src1, double src2);
unsigned int execute_setp_gt_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_gt_s32 (int32_t src1, int32_t src2);
unsigned int execute_setp_gt_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_gt_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_gt_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_gt_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_gtu_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_f32 (float src1, float src2);
unsigned int execute_setp_gtu_f64 (double src1, double src2);
unsigned int execute_setp_gtu_ftz_f32 (float src1, float src2);
unsigned int execute_setp_gtu_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_hi_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_hi_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_hi_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_hs_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_hs_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_hs_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_f32 (float src1, float src2);
unsigned int execute_setp_le_f64 (double src1, double src2);
unsigned int execute_setp_le_ftz_f32 (float src1, float src2);
unsigned int execute_setp_le_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_le_s32 (int32_t src1, int32_t src2);
unsigned int execute_setp_le_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_le_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_le_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_leu_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_f32 (float src1, float src2);
unsigned int execute_setp_leu_ftz_f32 (float src1, float src2);
unsigned int execute_setp_leu_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_leu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_lo_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_lo_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_lo_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_ls_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_ls_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_ls_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_f64 (double src1, double src2);
unsigned int execute_setp_lt_ftz_f32 (float src1, float src2);
unsigned int execute_setp_lt_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_lt_s32 (int32_t src1, int32_t src2);
unsigned int execute_setp_lt_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_lt_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_lt_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_ltu_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_f32 (float src1, float src2);
unsigned int execute_setp_ltu_f64 (double src1, double src2);
unsigned int execute_setp_ltu_ftz_f32 (float src1, float src2);
unsigned int execute_setp_ltu_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ltu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_f32 (float src1, float src2);
unsigned int execute_setp_nan_f64 (double src1, double src2);
unsigned int execute_setp_nan_ftz_f32 (float src1, float src2);
unsigned int execute_setp_nan_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_nan_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_b16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_ne_b32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_ne_b64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_ne_f32 (float src1, float src2);
unsigned int execute_setp_ne_f64 (double src1, double src2);
unsigned int execute_setp_ne_ftz_f32 (float src1, float src2);
unsigned int execute_setp_ne_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_s16 (int16_t src1, int16_t src2);
unsigned int execute_setp_ne_s32 (int32_t src1, int32_t src2);
unsigned int execute_setp_ne_s64 (int64_t src1, int64_t src2);
unsigned int execute_setp_ne_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_setp_ne_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_ne_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_neu_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_neu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_neu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_f32 (float src1, float src2);
unsigned int execute_setp_neu_f64 (double src1, double src2);
unsigned int execute_setp_neu_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_neu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_neu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_neu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_neu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_f64 (double src1, double src2);
unsigned int execute_setp_num_ftz_f32 (float src1, float src2);
unsigned int execute_setp_num_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_xor_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_num_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_b16  execute_setp_q_eq_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_b32  execute_setp_q_eq_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_b64  execute_setp_q_eq_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_f32  execute_setp_q_eq_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_f64  execute_setp_q_eq_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_b16  execute_setp_q_eq_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_b32  execute_setp_q_eq_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_b64  execute_setp_q_eq_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_f32  execute_setp_q_eq_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_f64  execute_setp_q_eq_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_ftz_f32  execute_setp_q_eq_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_s16  execute_setp_q_eq_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_s32  execute_setp_q_eq_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_s64  execute_setp_q_eq_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_u16  execute_setp_q_eq_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_u32  execute_setp_q_eq_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_invert_u64  execute_setp_q_eq_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_s16  execute_setp_q_eq_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_s32  execute_setp_q_eq_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_s64  execute_setp_q_eq_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_u16  execute_setp_q_eq_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_u32  execute_setp_q_eq_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_u64  execute_setp_q_eq_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_b16  execute_setp_q_eq_b16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_eq_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_b32  execute_setp_q_eq_b32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_eq_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_b64  execute_setp_q_eq_b64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_eq_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_f32  execute_setp_q_eq_f32 (float src1, float src2);
struct retval_setp_q_eq_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_f64  execute_setp_q_eq_f64 (double src1, double src2);
struct retval_setp_q_eq_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_ftz_f32  execute_setp_q_eq_ftz_f32 (float src1, float src2);
struct retval_setp_q_eq_or_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_b16  execute_setp_q_eq_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_b32  execute_setp_q_eq_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_b64  execute_setp_q_eq_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_f32  execute_setp_q_eq_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_f64  execute_setp_q_eq_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_ftz_f32  execute_setp_q_eq_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_b16  execute_setp_q_eq_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_b32  execute_setp_q_eq_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_b64  execute_setp_q_eq_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_f32  execute_setp_q_eq_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_f64  execute_setp_q_eq_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_ftz_f32  execute_setp_q_eq_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_s16  execute_setp_q_eq_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_s32  execute_setp_q_eq_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_s64  execute_setp_q_eq_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_u16  execute_setp_q_eq_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_u32  execute_setp_q_eq_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_invert_u64  execute_setp_q_eq_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_s16  execute_setp_q_eq_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_s32  execute_setp_q_eq_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_s64  execute_setp_q_eq_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_u16  execute_setp_q_eq_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_u32  execute_setp_q_eq_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_or_u64  execute_setp_q_eq_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_s16  execute_setp_q_eq_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_eq_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_s32  execute_setp_q_eq_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_eq_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_s64  execute_setp_q_eq_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_eq_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_u16  execute_setp_q_eq_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_eq_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_u32  execute_setp_q_eq_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_eq_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_u64  execute_setp_q_eq_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_equ_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_f32  execute_setp_q_equ_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_f64  execute_setp_q_equ_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_equ_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_invert_f32  execute_setp_q_equ_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_invert_f64  execute_setp_q_equ_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_equ_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_invert_ftz_f32  execute_setp_q_equ_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_f32  execute_setp_q_equ_f32 (float src1, float src2);
struct retval_setp_q_equ_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_f64  execute_setp_q_equ_f64 (double src1, double src2);
struct retval_setp_q_equ_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_ftz_f32  execute_setp_q_equ_ftz_f32 (float src1, float src2);
struct retval_setp_q_equ_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_f32  execute_setp_q_equ_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_f64  execute_setp_q_equ_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_equ_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_ftz_f32  execute_setp_q_equ_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_invert_f64  execute_setp_q_equ_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_equ_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_invert_ftz_f32  execute_setp_q_equ_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_f32  execute_setp_q_equ_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_f64  execute_setp_q_equ_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_ftz_f32  execute_setp_q_equ_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_invert_f32  execute_setp_q_equ_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_invert_f64  execute_setp_q_equ_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_b16  execute_setp_q_eq_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_b32  execute_setp_q_eq_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_b64  execute_setp_q_eq_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_f32  execute_setp_q_eq_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_f64  execute_setp_q_eq_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_ftz_f32  execute_setp_q_eq_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_b16  execute_setp_q_eq_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_b32  execute_setp_q_eq_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_b64  execute_setp_q_eq_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_f32  execute_setp_q_eq_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_f64  execute_setp_q_eq_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_ftz_f32  execute_setp_q_eq_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_s16  execute_setp_q_eq_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_s32  execute_setp_q_eq_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_s64  execute_setp_q_eq_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_u16  execute_setp_q_eq_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_u32  execute_setp_q_eq_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_invert_u64  execute_setp_q_eq_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_s16  execute_setp_q_eq_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_s32  execute_setp_q_eq_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_s64  execute_setp_q_eq_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_u16  execute_setp_q_eq_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_u32  execute_setp_q_eq_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_eq_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_xor_u64  execute_setp_q_eq_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_f32  execute_setp_q_ge_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_f64  execute_setp_q_ge_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_ftz_f32  execute_setp_q_ge_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_f32  execute_setp_q_ge_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_f64  execute_setp_q_ge_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_ftz_f32  execute_setp_q_ge_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_s16  execute_setp_q_ge_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_s32  execute_setp_q_ge_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_s64  execute_setp_q_ge_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_u16  execute_setp_q_ge_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_u32  execute_setp_q_ge_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_invert_u64  execute_setp_q_ge_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_s16  execute_setp_q_ge_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_s32  execute_setp_q_ge_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_s64  execute_setp_q_ge_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_u16  execute_setp_q_ge_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_u32  execute_setp_q_ge_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_and_u64  execute_setp_q_ge_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_f32  execute_setp_q_ge_f32 (float src1, float src2);
struct retval_setp_q_ge_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_f64  execute_setp_q_ge_f64 (double src1, double src2);
struct retval_setp_q_ge_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_ftz_f32  execute_setp_q_ge_ftz_f32 (float src1, float src2);
struct retval_setp_q_ge_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_f32  execute_setp_q_ge_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_ftz_f32  execute_setp_q_ge_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_f32  execute_setp_q_ge_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_f64  execute_setp_q_ge_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_ftz_f32  execute_setp_q_ge_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_s16  execute_setp_q_ge_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_s32  execute_setp_q_ge_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_s64  execute_setp_q_ge_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_u16  execute_setp_q_ge_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_u32  execute_setp_q_ge_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_invert_u64  execute_setp_q_ge_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_s16  execute_setp_q_ge_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_s32  execute_setp_q_ge_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_s64  execute_setp_q_ge_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_u16  execute_setp_q_ge_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_u32  execute_setp_q_ge_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_u64  execute_setp_q_ge_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_s16  execute_setp_q_ge_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_ge_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_s32  execute_setp_q_ge_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_ge_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_u16  execute_setp_q_ge_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_ge_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_u32  execute_setp_q_ge_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_ge_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_u64  execute_setp_q_ge_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_geu_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_f32  execute_setp_q_geu_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_f64  execute_setp_q_geu_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_ftz_f32  execute_setp_q_geu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_invert_f32  execute_setp_q_geu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_invert_f64  execute_setp_q_geu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_and_invert_ftz_f32  execute_setp_q_geu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_f32  execute_setp_q_geu_f32 (float src1, float src2);
struct retval_setp_q_geu_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_f64  execute_setp_q_geu_f64 (double src1, double src2);
struct retval_setp_q_geu_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_ftz_f32  execute_setp_q_geu_ftz_f32 (float src1, float src2);
struct retval_setp_q_geu_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_f32  execute_setp_q_geu_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_f64  execute_setp_q_geu_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_ftz_f32  execute_setp_q_geu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_invert_f32  execute_setp_q_geu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_invert_f64  execute_setp_q_geu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_or_invert_ftz_f32  execute_setp_q_geu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_f32  execute_setp_q_geu_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_f64  execute_setp_q_geu_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_ftz_f32  execute_setp_q_geu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_invert_f32  execute_setp_q_geu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_invert_f64  execute_setp_q_geu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_geu_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_geu_xor_invert_ftz_f32  execute_setp_q_geu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_f32  execute_setp_q_ge_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_f64  execute_setp_q_ge_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_ftz_f32  execute_setp_q_ge_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_f32  execute_setp_q_ge_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_f64  execute_setp_q_ge_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_ftz_f32  execute_setp_q_ge_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_s16  execute_setp_q_ge_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_s32  execute_setp_q_ge_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_s64  execute_setp_q_ge_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_u16  execute_setp_q_ge_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_u32  execute_setp_q_ge_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_invert_u64  execute_setp_q_ge_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_s16  execute_setp_q_ge_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_s32  execute_setp_q_ge_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_s64  execute_setp_q_ge_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_u16  execute_setp_q_ge_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_u32  execute_setp_q_ge_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ge_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_xor_u64  execute_setp_q_ge_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_f32  execute_setp_q_gt_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_f64  execute_setp_q_gt_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_ftz_f32  execute_setp_q_gt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_f32  execute_setp_q_gt_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_f64  execute_setp_q_gt_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_ftz_f32  execute_setp_q_gt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_s32  execute_setp_q_gt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_s64  execute_setp_q_gt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_u16  execute_setp_q_gt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_u32  execute_setp_q_gt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_s16  execute_setp_q_gt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_s32  execute_setp_q_gt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_s64  execute_setp_q_gt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_u16  execute_setp_q_gt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_u32  execute_setp_q_gt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_u64  execute_setp_q_gt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_f32  execute_setp_q_gt_f32 (float src1, float src2);
struct retval_setp_q_gt_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_f64  execute_setp_q_gt_f64 (double src1, double src2);
struct retval_setp_q_gt_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_f32  execute_setp_q_gt_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_f64  execute_setp_q_gt_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_ftz_f32  execute_setp_q_gt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_f32  execute_setp_q_gt_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_f64  execute_setp_q_gt_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_ftz_f32  execute_setp_q_gt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_s16  execute_setp_q_gt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_s32  execute_setp_q_gt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_s64  execute_setp_q_gt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_u16  execute_setp_q_gt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_u32  execute_setp_q_gt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_invert_u64  execute_setp_q_gt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_s16  execute_setp_q_gt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_s32  execute_setp_q_gt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_s64  execute_setp_q_gt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_u16  execute_setp_q_gt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_u32  execute_setp_q_gt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_or_u64  execute_setp_q_gt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_s16  execute_setp_q_gt_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_gt_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_s32  execute_setp_q_gt_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_gt_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_s64  execute_setp_q_gt_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_gt_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_u16  execute_setp_q_gt_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_gt_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_u32  execute_setp_q_gt_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_gt_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_u64  execute_setp_q_gt_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_gtu_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_f32  execute_setp_q_gtu_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_f64  execute_setp_q_gtu_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_invert_f32  execute_setp_q_gtu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_invert_f64  execute_setp_q_gtu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_f32  execute_setp_q_gtu_f32 (float src1, float src2);
struct retval_setp_q_gtu_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_f64  execute_setp_q_gtu_f64 (double src1, double src2);
struct retval_setp_q_gtu_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_ftz_f32  execute_setp_q_gtu_ftz_f32 (float src1, float src2);
struct retval_setp_q_gtu_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_f32  execute_setp_q_gtu_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_f64  execute_setp_q_gtu_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_invert_f32  execute_setp_q_gtu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_invert_f64  execute_setp_q_gtu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_invert_ftz_f32  execute_setp_q_gtu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_f32  execute_setp_q_gtu_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_f64  execute_setp_q_gtu_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_ftz_f32  execute_setp_q_gtu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_invert_f32  execute_setp_q_gtu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_invert_f64  execute_setp_q_gtu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gtu_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_xor_invert_ftz_f32  execute_setp_q_gtu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_f32  execute_setp_q_gt_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_f64  execute_setp_q_gt_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_f32  execute_setp_q_gt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_f64  execute_setp_q_gt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_ftz_f32  execute_setp_q_gt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_s16  execute_setp_q_gt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_s32  execute_setp_q_gt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_s64  execute_setp_q_gt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_u16  execute_setp_q_gt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_u32  execute_setp_q_gt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_invert_u64  execute_setp_q_gt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_s16  execute_setp_q_gt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_s32  execute_setp_q_gt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_s64  execute_setp_q_gt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_u16  execute_setp_q_gt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_u32  execute_setp_q_gt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_u64  execute_setp_q_gt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_invert_u16  execute_setp_q_hi_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_invert_u32  execute_setp_q_hi_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_invert_u64  execute_setp_q_hi_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_u16  execute_setp_q_hi_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_u32  execute_setp_q_hi_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_invert_u16  execute_setp_q_hi_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_invert_u32  execute_setp_q_hi_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_invert_u64  execute_setp_q_hi_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_u16  execute_setp_q_hi_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_u32  execute_setp_q_hi_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_or_u64  execute_setp_q_hi_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_u16  execute_setp_q_hi_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_hi_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_u32  execute_setp_q_hi_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_hi_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_invert_u16  execute_setp_q_hi_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_invert_u32  execute_setp_q_hi_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_invert_u64  execute_setp_q_hi_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_u16  execute_setp_q_hi_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_u32  execute_setp_q_hi_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_xor_u64  execute_setp_q_hi_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_invert_u16  execute_setp_q_hs_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_invert_u32  execute_setp_q_hs_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_invert_u64  execute_setp_q_hs_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_u16  execute_setp_q_hs_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_u32  execute_setp_q_hs_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_and_u64  execute_setp_q_hs_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_invert_u16  execute_setp_q_hs_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_invert_u32  execute_setp_q_hs_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_invert_u64  execute_setp_q_hs_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_u16  execute_setp_q_hs_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_u32  execute_setp_q_hs_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_or_u64  execute_setp_q_hs_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_u16  execute_setp_q_hs_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_hs_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_u32  execute_setp_q_hs_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_hs_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_invert_u16  execute_setp_q_hs_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_invert_u32  execute_setp_q_hs_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_invert_u64  execute_setp_q_hs_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_u16  execute_setp_q_hs_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_u32  execute_setp_q_hs_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_hs_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_xor_u64  execute_setp_q_hs_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_f32  execute_setp_q_le_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_f64  execute_setp_q_le_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_ftz_f32  execute_setp_q_le_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_f32  execute_setp_q_le_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_f64  execute_setp_q_le_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_ftz_f32  execute_setp_q_le_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_s16  execute_setp_q_le_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_s32  execute_setp_q_le_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_s64  execute_setp_q_le_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_u16  execute_setp_q_le_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_u32  execute_setp_q_le_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_invert_u64  execute_setp_q_le_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_s16  execute_setp_q_le_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_s32  execute_setp_q_le_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_s64  execute_setp_q_le_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_u16  execute_setp_q_le_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_u32  execute_setp_q_le_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_and_u64  execute_setp_q_le_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_f32  execute_setp_q_le_f32 (float src1, float src2);
struct retval_setp_q_le_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_f64  execute_setp_q_le_f64 (double src1, double src2);
struct retval_setp_q_le_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_ftz_f32  execute_setp_q_le_ftz_f32 (float src1, float src2);
struct retval_setp_q_le_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_f32  execute_setp_q_le_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_f64  execute_setp_q_le_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_ftz_f32  execute_setp_q_le_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_f32  execute_setp_q_le_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_f64  execute_setp_q_le_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_ftz_f32  execute_setp_q_le_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_s16  execute_setp_q_le_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_s32  execute_setp_q_le_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_s64  execute_setp_q_le_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_u16  execute_setp_q_le_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_u32  execute_setp_q_le_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_invert_u64  execute_setp_q_le_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_s16  execute_setp_q_le_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_s32  execute_setp_q_le_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_s64  execute_setp_q_le_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_u16  execute_setp_q_le_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_u32  execute_setp_q_le_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_or_u64  execute_setp_q_le_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_s16  execute_setp_q_le_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_le_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_s32  execute_setp_q_le_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_le_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_s64  execute_setp_q_le_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_le_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_u32  execute_setp_q_le_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_le_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_u64  execute_setp_q_le_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_leu_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_f32  execute_setp_q_leu_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_f64  execute_setp_q_leu_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_ftz_f32  execute_setp_q_leu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_invert_f32  execute_setp_q_leu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_invert_f64  execute_setp_q_leu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_and_invert_ftz_f32  execute_setp_q_leu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_f32  execute_setp_q_leu_f32 (float src1, float src2);
struct retval_setp_q_leu_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_f64  execute_setp_q_leu_f64 (double src1, double src2);
struct retval_setp_q_leu_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_ftz_f32  execute_setp_q_leu_ftz_f32 (float src1, float src2);
struct retval_setp_q_leu_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_f64  execute_setp_q_leu_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_ftz_f32  execute_setp_q_leu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_invert_f32  execute_setp_q_leu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_invert_f64  execute_setp_q_leu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_invert_ftz_f32  execute_setp_q_leu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_f32  execute_setp_q_leu_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_f64  execute_setp_q_leu_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_ftz_f32  execute_setp_q_leu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_invert_f32  execute_setp_q_leu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_invert_f64  execute_setp_q_leu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_leu_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_xor_invert_ftz_f32  execute_setp_q_leu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_f32  execute_setp_q_le_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_f64  execute_setp_q_le_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_f32  execute_setp_q_le_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_f64  execute_setp_q_le_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_ftz_f32  execute_setp_q_le_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_s16  execute_setp_q_le_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_s32  execute_setp_q_le_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_s64  execute_setp_q_le_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_u16  execute_setp_q_le_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_u32  execute_setp_q_le_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_invert_u64  execute_setp_q_le_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_s16  execute_setp_q_le_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_s32  execute_setp_q_le_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_s64  execute_setp_q_le_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_u16  execute_setp_q_le_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_u32  execute_setp_q_le_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_u64  execute_setp_q_le_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_invert_u16  execute_setp_q_lo_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_invert_u32  execute_setp_q_lo_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_invert_u64  execute_setp_q_lo_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_u16  execute_setp_q_lo_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_u32  execute_setp_q_lo_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_and_u64  execute_setp_q_lo_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_invert_u16  execute_setp_q_lo_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_invert_u32  execute_setp_q_lo_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_invert_u64  execute_setp_q_lo_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_u16  execute_setp_q_lo_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_u32  execute_setp_q_lo_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_or_u64  execute_setp_q_lo_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_u16  execute_setp_q_lo_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_lo_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_u32  execute_setp_q_lo_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_lo_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_invert_u16  execute_setp_q_lo_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_invert_u32  execute_setp_q_lo_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_invert_u64  execute_setp_q_lo_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_u16  execute_setp_q_lo_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_u32  execute_setp_q_lo_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lo_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_xor_u64  execute_setp_q_lo_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_invert_u16  execute_setp_q_ls_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_invert_u32  execute_setp_q_ls_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_invert_u64  execute_setp_q_ls_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_u16  execute_setp_q_ls_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_u32  execute_setp_q_ls_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_and_u64  execute_setp_q_ls_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_invert_u16  execute_setp_q_ls_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_invert_u32  execute_setp_q_ls_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_invert_u64  execute_setp_q_ls_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_u16  execute_setp_q_ls_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_u64  execute_setp_q_ls_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_u16  execute_setp_q_ls_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_ls_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_u32  execute_setp_q_ls_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_ls_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_u64  execute_setp_q_ls_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_ls_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_invert_u16  execute_setp_q_ls_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_invert_u64  execute_setp_q_ls_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_u16  execute_setp_q_ls_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_u32  execute_setp_q_ls_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_u64  execute_setp_q_ls_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_f32  execute_setp_q_lt_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_f64  execute_setp_q_lt_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_f32  execute_setp_q_lt_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_f64  execute_setp_q_lt_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_ftz_f32  execute_setp_q_lt_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_s16  execute_setp_q_lt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_s32  execute_setp_q_lt_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_s64  execute_setp_q_lt_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_u16  execute_setp_q_lt_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_u32  execute_setp_q_lt_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_invert_u64  execute_setp_q_lt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_s16  execute_setp_q_lt_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_s32  execute_setp_q_lt_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_s64  execute_setp_q_lt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_u16  execute_setp_q_lt_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_u32  execute_setp_q_lt_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_u64  execute_setp_q_lt_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_f32  execute_setp_q_lt_f32 (float src1, float src2);
struct retval_setp_q_lt_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_f64  execute_setp_q_lt_f64 (double src1, double src2);
struct retval_setp_q_lt_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_ftz_f32  execute_setp_q_lt_ftz_f32 (float src1, float src2);
struct retval_setp_q_lt_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_f32  execute_setp_q_lt_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_f64  execute_setp_q_lt_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_ftz_f32  execute_setp_q_lt_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_f32  execute_setp_q_lt_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_f64  execute_setp_q_lt_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_ftz_f32  execute_setp_q_lt_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_s16  execute_setp_q_lt_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_s32  execute_setp_q_lt_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_s64  execute_setp_q_lt_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_u16  execute_setp_q_lt_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_u32  execute_setp_q_lt_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_invert_u64  execute_setp_q_lt_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_s16  execute_setp_q_lt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_s32  execute_setp_q_lt_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_s64  execute_setp_q_lt_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_u16  execute_setp_q_lt_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_u32  execute_setp_q_lt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_or_u64  execute_setp_q_lt_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_s16  execute_setp_q_lt_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_lt_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_s32  execute_setp_q_lt_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_lt_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_s64  execute_setp_q_lt_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_lt_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_u16  execute_setp_q_lt_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_lt_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_u64  execute_setp_q_lt_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_ltu_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_f32  execute_setp_q_ltu_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_f64  execute_setp_q_ltu_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ltu_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_ftz_f32  execute_setp_q_ltu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_invert_f64  execute_setp_q_ltu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ltu_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_invert_ftz_f32  execute_setp_q_ltu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_f32  execute_setp_q_ltu_f32 (float src1, float src2);
struct retval_setp_q_ltu_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_f64  execute_setp_q_ltu_f64 (double src1, double src2);
struct retval_setp_q_ltu_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_ftz_f32  execute_setp_q_ltu_ftz_f32 (float src1, float src2);
struct retval_setp_q_ltu_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_f32  execute_setp_q_ltu_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_f64  execute_setp_q_ltu_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ltu_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_ftz_f32  execute_setp_q_ltu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_invert_f32  execute_setp_q_ltu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_invert_f64  execute_setp_q_ltu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ltu_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_or_invert_ftz_f32  execute_setp_q_ltu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_f32  execute_setp_q_ltu_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_f64  execute_setp_q_ltu_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_ftz_f32  execute_setp_q_ltu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_invert_f32  execute_setp_q_ltu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_invert_f64  execute_setp_q_ltu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_f32  execute_setp_q_lt_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_f64  execute_setp_q_lt_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_ftz_f32  execute_setp_q_lt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_f32  execute_setp_q_lt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_f64  execute_setp_q_lt_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_ftz_f32  execute_setp_q_lt_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_s16  execute_setp_q_lt_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_s32  execute_setp_q_lt_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_s64  execute_setp_q_lt_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_u16  execute_setp_q_lt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_u32  execute_setp_q_lt_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_invert_u64  execute_setp_q_lt_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_s16  execute_setp_q_lt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_s32  execute_setp_q_lt_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_s64  execute_setp_q_lt_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_u16  execute_setp_q_lt_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_u32  execute_setp_q_lt_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_xor_u64  execute_setp_q_lt_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_f32  execute_setp_q_nan_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_f64  execute_setp_q_nan_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_ftz_f32  execute_setp_q_nan_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_invert_f32  execute_setp_q_nan_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_invert_f64  execute_setp_q_nan_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_and_invert_ftz_f32  execute_setp_q_nan_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_f32  execute_setp_q_nan_f32 (float src1, float src2);
struct retval_setp_q_nan_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_f64  execute_setp_q_nan_f64 (double src1, double src2);
struct retval_setp_q_nan_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_ftz_f32  execute_setp_q_nan_ftz_f32 (float src1, float src2);
struct retval_setp_q_nan_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_f32  execute_setp_q_nan_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_ftz_f32  execute_setp_q_nan_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_invert_f32  execute_setp_q_nan_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_invert_ftz_f32  execute_setp_q_nan_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_f32  execute_setp_q_nan_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_f64  execute_setp_q_nan_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_ftz_f32  execute_setp_q_nan_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_invert_f64  execute_setp_q_nan_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_invert_ftz_f32  execute_setp_q_nan_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_b16  execute_setp_q_ne_and_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_b32  execute_setp_q_ne_and_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_b64  execute_setp_q_ne_and_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_f32  execute_setp_q_ne_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_f64  execute_setp_q_ne_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_b16  execute_setp_q_ne_and_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_b32  execute_setp_q_ne_and_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_f32  execute_setp_q_ne_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_f64  execute_setp_q_ne_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_ftz_f32  execute_setp_q_ne_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_s16  execute_setp_q_ne_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_s32  execute_setp_q_ne_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_s64  execute_setp_q_ne_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_u16  execute_setp_q_ne_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_u32  execute_setp_q_ne_and_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_u64  execute_setp_q_ne_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_s16  execute_setp_q_ne_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_s32  execute_setp_q_ne_and_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_s64  execute_setp_q_ne_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_u16  execute_setp_q_ne_and_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_u32  execute_setp_q_ne_and_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_u64  execute_setp_q_ne_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_b16  execute_setp_q_ne_b16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_ne_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_b32  execute_setp_q_ne_b32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_ne_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_b64  execute_setp_q_ne_b64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_ne_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_f32  execute_setp_q_ne_f32 (float src1, float src2);
struct retval_setp_q_ne_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_f64  execute_setp_q_ne_f64 (double src1, double src2);
struct retval_setp_q_ne_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_ftz_f32  execute_setp_q_ne_ftz_f32 (float src1, float src2);
struct retval_setp_q_ne_or_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_b16  execute_setp_q_ne_or_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_b32  execute_setp_q_ne_or_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_b64  execute_setp_q_ne_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_f32  execute_setp_q_ne_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_f64  execute_setp_q_ne_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_ftz_f32  execute_setp_q_ne_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_b16  execute_setp_q_ne_or_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_b32  execute_setp_q_ne_or_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_f64  execute_setp_q_ne_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_ftz_f32  execute_setp_q_ne_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_s16  execute_setp_q_ne_or_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_s32  execute_setp_q_ne_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_s64  execute_setp_q_ne_or_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_u16  execute_setp_q_ne_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_u32  execute_setp_q_ne_or_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_u64  execute_setp_q_ne_or_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_s16  execute_setp_q_ne_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_s32  execute_setp_q_ne_or_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_s64  execute_setp_q_ne_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_u16  execute_setp_q_ne_or_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_u32  execute_setp_q_ne_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_u64  execute_setp_q_ne_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_s16  execute_setp_q_ne_s16 (int16_t src1, int16_t src2);
struct retval_setp_q_ne_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_s32  execute_setp_q_ne_s32 (int32_t src1, int32_t src2);
struct retval_setp_q_ne_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_s64  execute_setp_q_ne_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_ne_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_u16  execute_setp_q_ne_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_ne_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_u32  execute_setp_q_ne_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_ne_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_u64  execute_setp_q_ne_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_neu_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_f32  execute_setp_q_neu_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_f64  execute_setp_q_neu_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_invert_f32  execute_setp_q_neu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_invert_f64  execute_setp_q_neu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_invert_ftz_f32  execute_setp_q_neu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_f32  execute_setp_q_neu_f32 (float src1, float src2);
struct retval_setp_q_neu_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_f64  execute_setp_q_neu_f64 (double src1, double src2);
struct retval_setp_q_neu_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_ftz_f32  execute_setp_q_neu_ftz_f32 (float src1, float src2);
struct retval_setp_q_neu_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_f64  execute_setp_q_neu_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_ftz_f32  execute_setp_q_neu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_invert_f32  execute_setp_q_neu_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_invert_f64  execute_setp_q_neu_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_invert_ftz_f32  execute_setp_q_neu_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_f64  execute_setp_q_neu_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_ftz_f32  execute_setp_q_neu_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_invert_f32  execute_setp_q_neu_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_b16  execute_setp_q_ne_xor_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_b64  execute_setp_q_ne_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_f32  execute_setp_q_ne_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_f64  execute_setp_q_ne_xor_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_ftz_f32  execute_setp_q_ne_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_b16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_b16  execute_setp_q_ne_xor_invert_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_b32  execute_setp_q_ne_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_b64  execute_setp_q_ne_xor_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_f64  execute_setp_q_ne_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_ftz_f32  execute_setp_q_ne_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_s16  execute_setp_q_ne_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_s32  execute_setp_q_ne_xor_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_s64  execute_setp_q_ne_xor_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_u16  execute_setp_q_ne_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_u32  execute_setp_q_ne_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_u64  execute_setp_q_ne_xor_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_s16  execute_setp_q_ne_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_s32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_s32  execute_setp_q_ne_xor_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_s64  execute_setp_q_ne_xor_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_u16  execute_setp_q_ne_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_u32  execute_setp_q_ne_xor_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_u64  execute_setp_q_ne_xor_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_num_and_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_f32  execute_setp_q_num_and_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_and_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_f64  execute_setp_q_num_and_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_num_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_ftz_f32  execute_setp_q_num_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_invert_f32  execute_setp_q_num_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_and_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_invert_f64  execute_setp_q_num_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_num_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_and_invert_ftz_f32  execute_setp_q_num_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_f32  execute_setp_q_num_f32 (float src1, float src2);
struct retval_setp_q_num_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_f64  execute_setp_q_num_f64 (double src1, double src2);
struct retval_setp_q_num_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_ftz_f32  execute_setp_q_num_ftz_f32 (float src1, float src2);
struct retval_setp_q_num_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_f32  execute_setp_q_num_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_f64  execute_setp_q_num_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_num_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_ftz_f32  execute_setp_q_num_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_invert_f32  execute_setp_q_num_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_invert_f64  execute_setp_q_num_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_f32  execute_setp_q_num_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_ftz_f32  execute_setp_q_num_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_invert_f32  execute_setp_q_num_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_invert_f64  execute_setp_q_num_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_invert_ftz_f32  execute_setp_q_num_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_shf_l_clamp_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_shf_l_wrap_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_shf_r_clamp_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint32_t execute_shf_r_wrap_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
uint16_t execute_shl_b16 (uint16_t src1, uint32_t src2);
uint32_t execute_shl_b32 (uint32_t src1, uint32_t src2);
uint64_t execute_shl_b64 (uint64_t src1, uint32_t src2);
uint16_t execute_shr_b16 (uint16_t src1, uint32_t src2);
uint32_t execute_shr_b32 (uint32_t src1, uint32_t src2);
uint64_t execute_shr_b64 (uint64_t src1, uint32_t src2);
int16_t execute_shr_s16 (int16_t src1, uint32_t src2);
int64_t execute_shr_s64 (int64_t src1, uint32_t src2);
uint16_t execute_shr_u16 (uint16_t src1, uint32_t src2);
uint32_t execute_shr_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_shr_u64 (uint64_t src1, uint32_t src2);
float execute_sin_approx_f32 (float src1);
float execute_sin_approx_ftz_f32 (float src1);
uint16_t execute_slct_b16_f32 (uint16_t src1, uint16_t src2, float src3);
uint16_t execute_slct_b16_s32 (uint16_t src1, uint16_t src2, int32_t src3);
uint32_t execute_slct_b32_f32 (uint32_t src1, uint32_t src2, float src3);
uint32_t execute_slct_b32_s32 (uint32_t src1, uint32_t src2, int32_t src3);
uint64_t execute_slct_b64_f32 (uint64_t src1, uint64_t src2, float src3);
uint64_t execute_slct_b64_s32 (uint64_t src1, uint64_t src2, int32_t src3);
float execute_slct_f32_f32 (float src1, float src2, float src3);
float execute_slct_f32_s32 (float src1, float src2, int32_t src3);
double execute_slct_f64_f32 (double src1, double src2, float src3);
double execute_slct_f64_s32 (double src1, double src2, int32_t src3);
uint16_t execute_slct_ftz_b16_f32 (uint16_t src1, uint16_t src2, float src3);
uint32_t execute_slct_ftz_b32_f32 (uint32_t src1, uint32_t src2, float src3);
uint64_t execute_slct_ftz_b64_f32 (uint64_t src1, uint64_t src2, float src3);
float execute_slct_ftz_f32_f32 (float src1, float src2, float src3);
double execute_slct_ftz_f64_f32 (double src1, double src2, float src3);
int16_t execute_slct_ftz_s16_f32 (int16_t src1, int16_t src2, float src3);
int32_t execute_slct_ftz_s32_f32 (int32_t src1, int32_t src2, float src3);
int64_t execute_slct_ftz_s64_f32 (int64_t src1, int64_t src2, float src3);
uint16_t execute_slct_ftz_u16_f32 (uint16_t src1, uint16_t src2, float src3);
uint32_t execute_slct_ftz_u32_f32 (uint32_t src1, uint32_t src2, float src3);
uint64_t execute_slct_ftz_u64_f32 (uint64_t src1, uint64_t src2, float src3);
int16_t execute_slct_s16_s32 (int16_t src1, int16_t src2, int32_t src3);
int32_t execute_slct_s32_f32 (int32_t src1, int32_t src2, float src3);
int32_t execute_slct_s32_s32 (int32_t src1, int32_t src2, int32_t src3);
int64_t execute_slct_s64_s32 (int64_t src1, int64_t src2, int32_t src3);
uint16_t execute_slct_u16_s32 (uint16_t src1, uint16_t src2, int32_t src3);
uint32_t execute_slct_u32_f32 (uint32_t src1, uint32_t src2, float src3);
uint32_t execute_slct_u32_s32 (uint32_t src1, uint32_t src2, int32_t src3);
uint64_t execute_slct_u64_f32 (uint64_t src1, uint64_t src2, float src3);
uint64_t execute_slct_u64_s32 (uint64_t src1, uint64_t src2, int32_t src3);
float execute_sqrt_approx_f32 (float src1);
float execute_sqrt_rm_f32 (float src1);
double execute_sqrt_rm_f64 (double src1);
float execute_sqrt_rm_ftz_f32 (float src1);
float execute_sqrt_rn_f32 (float src1);
double execute_sqrt_rn_f64 (double src1);
float execute_sqrt_rn_ftz_f32 (float src1);
float execute_sqrt_rp_f32 (float src1);
double execute_sqrt_rp_f64 (double src1);
float execute_sqrt_rz_f32 (float src1);
double execute_sqrt_rz_f64 (double src1);
float execute_sqrt_rz_ftz_f32 (float src1);
uint32_t execute_sub_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg);
int64_t execute_subc_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg);
uint32_t execute_subc_cc_u32 (uint32_t src1, uint32_t src2, struct cc_register * cc_reg);
int32_t execute_sub_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg);
int64_t execute_sub_cc_s64 (int64_t src1, int64_t src2, struct cc_register * cc_reg);
uint64_t execute_sub_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg);
float execute_sub_f32 (float src1, float src2);
double execute_sub_f64 (double src1, double src2);
float execute_sub_ftz_f32 (float src1, float src2);
float execute_sub_ftz_sat_f32 (float src1, float src2);
float execute_sub_rm_f32 (float src1, float src2);
double execute_sub_rm_f64 (double src1, double src2);
float execute_sub_rm_ftz_f32 (float src1, float src2);
float execute_sub_rm_ftz_sat_f32 (float src1, float src2);
float execute_sub_rm_sat_f32 (float src1, float src2);
float execute_sub_rn_f32 (float src1, float src2);
double execute_sub_rn_f64 (double src1, double src2);
float execute_sub_rn_ftz_f32 (float src1, float src2);
float execute_sub_rn_ftz_sat_f32 (float src1, float src2);
float execute_sub_rn_sat_f32 (float src1, float src2);
float execute_sub_rp_f32 (float src1, float src2);
double execute_sub_rp_f64 (double src1, double src2);
float execute_sub_rp_ftz_f32 (float src1, float src2);
float execute_sub_rp_ftz_sat_f32 (float src1, float src2);
float execute_sub_rp_sat_f32 (float src1, float src2);
float execute_sub_rz_f32 (float src1, float src2);
double execute_sub_rz_f64 (double src1, double src2);
float execute_sub_rz_ftz_f32 (float src1, float src2);
float execute_sub_rz_ftz_sat_f32 (float src1, float src2);
float execute_sub_rz_sat_f32 (float src1, float src2);
int16_t execute_sub_s16 (int16_t src1, int16_t src2);
int32_t execute_sub_s32 (int32_t src1, int32_t src2);
int64_t execute_sub_s64 (int64_t src1, int64_t src2);
float execute_sub_sat_f32 (float src1, float src2);
int32_t execute_sub_sat_s32 (int32_t src1, int32_t src2);
uint32_t execute_sub_u32 (uint32_t src1, uint32_t src2);
uint64_t execute_sub_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_testp_finite_f32 (float src1);
unsigned int execute_testp_finite_f64 (double src1);
unsigned int execute_testp_infinite_f32 (float src1);
unsigned int execute_testp_infinite_f64 (double src1);
unsigned int execute_testp_normal_f64 (double src1);
unsigned int execute_testp_notanumber_f32 (float src1);
unsigned int execute_testp_notanumber_f64 (double src1);
unsigned int execute_testp_number_f32 (float src1);
unsigned int execute_testp_number_f64 (double src1);
unsigned int execute_testp_subnormal_f32 (float src1);
unsigned int execute_testp_subnormal_f64 (double src1);
uint16_t execute_xor_b16 (uint16_t src1, uint16_t src2);
uint32_t execute_xor_b32 (uint32_t src1, uint32_t src2);
uint64_t execute_xor_b64 (uint64_t src1, uint64_t src2);
unsigned int execute_xor_pred (unsigned int src1, unsigned int src2);
int32_t execute_add_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg);
int32_t execute_addc_s32 (int32_t src1, int32_t src2, struct cc_register cc_reg);
int64_t execute_addc_s64 (int64_t src1, int64_t src2, struct cc_register cc_reg);
uint64_t execute_addc_u64 (uint64_t src1, uint64_t src2, struct cc_register cc_reg);
int64_t execute_add_s64 (int64_t src1, int64_t src2);
uint64_t execute_add_u64 (uint64_t src1, uint64_t src2);
uint32_t execute_clz_b64 (uint64_t src2);
float execute_cos_approx_ftz_f32 (float src1);
float execute_div_rm_f32 (float src1, float src2);
float execute_fma_rp_sat_f32 (float src1, float src2, float src3);
float execute_lg2_approx_ftz_f32 (float src1);
int32_t execute_madc_hi_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register cc_reg);
int64_t execute_madc_hi_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register cc_reg);
uint32_t execute_madc_hi_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register cc_reg);
uint64_t execute_madc_hi_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register cc_reg);
uint64_t execute_madc_lo_cc_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register * cc_reg);
int32_t execute_madc_lo_s32 (int32_t src1, int32_t src2, int32_t src3, struct cc_register cc_reg);
int64_t execute_madc_lo_s64 (int64_t src1, int64_t src2, int64_t src3, struct cc_register cc_reg);
uint32_t execute_madc_lo_u32 (uint32_t src1, uint32_t src2, uint32_t src3, struct cc_register cc_reg);
uint64_t execute_madc_lo_u64 (uint64_t src1, uint64_t src2, uint64_t src3, struct cc_register cc_reg);
uint64_t execute_mad_hi_u64 (uint64_t src1, uint64_t src2, uint64_t src3);
double execute_mad_rm_f64 (double src1, double src2, double src3);
uint16_t execute_min_u16 (uint16_t src1, uint16_t src2);
int64_t execute_mul_hi_s64 (int64_t src1, int64_t src2);
uint16_t execute_mul_lo_u16 (uint16_t src1, uint16_t src2);
uint64_t execute_not_b64 (uint64_t src1);
uint32_t execute_prmt_f4e_b32 (uint32_t src1, uint32_t src2, uint32_t src3);
double execute_rcp_approx_ftz_f64 (double src1);
float execute_rcp_rm_ftz_f32 (float src1);
float execute_rcp_rz_f32 (float src1);
int16_t execute_rem_s16 (int16_t src1, int16_t src2);
uint32_t execute_rem_u32 (uint32_t src1, uint32_t src2);
float execute_rsqrt_approx_ftz_f32 (float src1);
float execute_set_eq_and_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_and_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_f32_b32 (uint32_t src1, uint32_t src2);
float execute_set_eq_f32_s32 (int32_t src1, int32_t src2);
float execute_set_eq_or_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_or_invert_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_u32_f32 (float src1, float src2);
uint32_t execute_set_eq_u32_f64 (double src1, double src2);
float execute_set_equ_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_and_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_equ_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_f32_f64 (double src1, double src2);
float execute_set_equ_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_u32_f64 (double src1, double src2);
float execute_set_equ_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_equ_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_equ_xor_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_equ_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_equ_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ge_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_f32_u16 (uint16_t src1, uint16_t src2);
float execute_set_ge_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ge_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ge_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_or_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ge_s32_s64 (int64_t src1, int64_t src2);
uint32_t execute_set_ge_u32_s64 (int64_t src1, int64_t src2);
float execute_set_geu_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_geu_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_geu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_geu_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_geu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_geu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ge_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ge_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ge_xor_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_and_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_f32_f64 (double src1, double src2);
float execute_set_gt_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_or_invert_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_s32_s32 (int32_t src1, int32_t src2);
float execute_set_gtu_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_f32_f32 (float src1, float src2);
float execute_set_gtu_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gtu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gtu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gtu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gtu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_gt_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_gt_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_gt_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hi_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_invert_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hi_f32_u64 (uint64_t src1, uint64_t src2);
float execute_set_hi_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hi_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hi_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hi_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hs_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hs_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_hs_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_hs_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_hs_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hs_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hs_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_le_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_leu_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_leu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_leu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_leu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_leu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_le_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_le_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_le_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_le_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_le_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_le_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_le_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_le_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lo_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lo_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_invert_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lo_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lo_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lo_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lo_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lo_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lo_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lo_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ls_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ls_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ls_and_invert_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ls_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ls_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ls_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ls_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_and_invert_f32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_and_invert_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_invert_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_f32_s64 (int64_t src1, int64_t src2);
float execute_set_lt_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_lt_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_or_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_or_invert_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ltu_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_or_invert_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ltu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ltu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ltu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ltu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_lt_xor_invert_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_invert_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_lt_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_nan_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_nan_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_nan_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_nan_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_nan_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_nan_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_and_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_and_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_invert_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_f32_s32 (int32_t src1, int32_t src2);
float execute_set_ne_or_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_or_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_invert_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_invert_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_s32_f32 (float src1, float src2);
float execute_set_neu_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_invert_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_neu_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_neu_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_neu_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_neu_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_xor_invert_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ne_xor_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_num_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_and_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_and_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_and_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_and_invert_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_and_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_and_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_and_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_or_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_or_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_or_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_or_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_or_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_xor_f32_f32 (float src1, float src2, unsigned int pred_reg);
float execute_set_num_xor_f32_f64 (double src1, double src2, unsigned int pred_reg);
float execute_set_num_xor_ftz_f32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_xor_ftz_s32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_ftz_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_invert_u32_f64 (double src1, double src2, unsigned int pred_reg);
int32_t execute_set_num_xor_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_num_xor_s32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_num_xor_u32_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_and_invert_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_eq_f32 (float src1, float src2);
unsigned int execute_setp_eq_or_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_eq_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_equ_or_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_eq_xor_invert_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_and_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_or_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_u64 (uint64_t src1, uint64_t src2);
unsigned int execute_setp_geu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ge_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_ftz_f32 (float src1, float src2);
unsigned int execute_setp_gt_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
unsigned int execute_setp_gtu_and_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_gt_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hi_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_hs_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_le_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_leu_and_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_leu_f64 (double src1, double src2);
unsigned int execute_setp_le_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_xor_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_or_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ls_xor_invert_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_f32 (float src1, float src2);
unsigned int execute_setp_lt_or_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_lt_u32 (uint32_t src1, uint32_t src2);
unsigned int execute_setp_ltu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
unsigned int execute_setp_lt_xor_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_and_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_invert_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
unsigned int execute_setp_ne_or_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_neu_ftz_f32 (float src1, float src2);
unsigned int execute_setp_neu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_ne_xor_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
unsigned int execute_setp_num_and_f64 (double src1, double src2, unsigned int pred_reg);
unsigned int execute_setp_num_f32 (float src1, float src2);
unsigned int execute_setp_num_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_eq_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_eq_and_ftz_f32  execute_setp_q_eq_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_and_ftz_f32  execute_setp_q_equ_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_or_invert_f32  execute_setp_q_equ_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_equ_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_equ_xor_invert_ftz_f32  execute_setp_q_equ_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ge_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_or_f64  execute_setp_q_ge_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_ge_s64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ge_s64  execute_setp_q_ge_s64 (int64_t src1, int64_t src2);
struct retval_setp_q_gt_and_invert_s16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_s16  execute_setp_q_gt_and_invert_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_and_invert_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_and_invert_u64  execute_setp_q_gt_and_invert_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_gt_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_ftz_f32  execute_setp_q_gt_ftz_f32 (float src1, float src2);
struct retval_setp_q_gtu_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_ftz_f32  execute_setp_q_gtu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_and_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_and_invert_ftz_f32  execute_setp_q_gtu_and_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gtu_or_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gtu_or_ftz_f32  execute_setp_q_gtu_or_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_gt_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_gt_xor_ftz_f32  execute_setp_q_gt_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_hi_and_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_and_u64  execute_setp_q_hi_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_hi_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hi_u64  execute_setp_q_hi_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_hs_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_hs_u64  execute_setp_q_hs_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_le_u16 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_u16  execute_setp_q_le_u16 (uint16_t src1, uint16_t src2);
struct retval_setp_q_leu_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_leu_or_f32  execute_setp_q_leu_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_le_xor_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_le_xor_ftz_f32  execute_setp_q_le_xor_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lo_u64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lo_u64  execute_setp_q_lo_u64 (uint64_t src1, uint64_t src2);
struct retval_setp_q_ls_or_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_or_u32  execute_setp_q_ls_or_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ls_xor_invert_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ls_xor_invert_u32  execute_setp_q_ls_xor_invert_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_lt_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_and_ftz_f32  execute_setp_q_lt_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_lt_u32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_lt_u32  execute_setp_q_lt_u32 (uint32_t src1, uint32_t src2);
struct retval_setp_q_ltu_and_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_and_invert_f32  execute_setp_q_ltu_and_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ltu_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ltu_xor_invert_ftz_f32  execute_setp_q_ltu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_nan_or_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_f64  execute_setp_q_nan_or_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_or_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_or_invert_f64  execute_setp_q_nan_or_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_nan_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_nan_xor_invert_f32  execute_setp_q_nan_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_ftz_f32  execute_setp_q_ne_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_and_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_and_invert_b64  execute_setp_q_ne_and_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_b64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_b64  execute_setp_q_ne_or_invert_b64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_or_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_or_invert_f32  execute_setp_q_ne_or_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_and_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_and_ftz_f32  execute_setp_q_neu_and_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_or_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_or_f32  execute_setp_q_neu_or_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_f32  execute_setp_q_neu_xor_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_invert_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_invert_f64  execute_setp_q_neu_xor_invert_f64 (double src1, double src2, unsigned int pred_reg);
struct retval_setp_q_neu_xor_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_neu_xor_invert_ftz_f32  execute_setp_q_neu_xor_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_b32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_b32  execute_setp_q_ne_xor_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
struct retval_setp_q_ne_xor_invert_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_ne_xor_invert_f32  execute_setp_q_ne_xor_invert_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_or_invert_ftz_f32 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_or_invert_ftz_f32  execute_setp_q_num_or_invert_ftz_f32 (float src1, float src2, unsigned int pred_reg);
struct retval_setp_q_num_xor_f64 { unsigned int out0; unsigned int out1;  };
struct retval_setp_q_num_xor_f64  execute_setp_q_num_xor_f64 (double src1, double src2, unsigned int pred_reg);
int16_t execute_slct_s16_f32 (int16_t src1, int16_t src2, float src3);
int64_t execute_slct_s64_f32 (int64_t src1, int64_t src2, float src3);
uint16_t execute_slct_u16_f32 (uint16_t src1, uint16_t src2, float src3);
float execute_sqrt_approx_ftz_f32 (float src1);
float execute_sqrt_rp_ftz_f32 (float src1);
int32_t execute_subc_cc_s32 (int32_t src1, int32_t src2, struct cc_register * cc_reg);
uint64_t execute_subc_cc_u64 (uint64_t src1, uint64_t src2, struct cc_register * cc_reg);
int32_t execute_subc_s32 (int32_t src1, int32_t src2, struct cc_register cc_reg);
int64_t execute_subc_s64 (int64_t src1, int64_t src2, struct cc_register cc_reg);
uint32_t execute_subc_u32 (uint32_t src1, uint32_t src2, struct cc_register cc_reg);
uint16_t execute_sub_u16 (uint16_t src1, uint16_t src2);
unsigned int execute_testp_normal_f32 (float src1);
int32_t execute_mul24_lo_s32 (int32_t src1, int32_t src2);
uint16_t execute_selp_b16 (uint16_t src1, uint16_t src2, unsigned int pred_src);
uint32_t execute_selp_b32 (uint32_t src1, uint32_t src2, unsigned int pred_src);
uint64_t execute_selp_b64 (uint64_t src1, uint64_t src2, unsigned int pred_src);
float execute_selp_f32 (float src1, float src2, unsigned int pred_src);
double execute_selp_f64 (double src1, double src2, unsigned int pred_src);
int16_t execute_selp_s16 (int16_t src1, int16_t src2, unsigned int pred_src);
int64_t execute_selp_s64 (int64_t src1, int64_t src2, unsigned int pred_src);
uint16_t execute_selp_u16 (uint16_t src1, uint16_t src2, unsigned int pred_src);
uint32_t execute_selp_u32 (uint32_t src1, uint32_t src2, unsigned int pred_src);
uint64_t execute_selp_u64 (uint64_t src1, uint64_t src2, unsigned int pred_src);
uint32_t execute_set_eq_and_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_eq_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_eq_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
float execute_set_eq_xor_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_eq_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_and_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ge_or_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_ge_or_f32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ge_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_ge_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_ge_xor_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_and_invert_s32_f32 (float src1, float src2, unsigned int pred_reg);
int32_t execute_set_gt_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_gt_xor_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_and_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_hi_xor_invert_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_hi_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_hs_and_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_le_and_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_f64 (double src1, double src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_leu_and_f32_f32 (float src1, float src2, unsigned int pred_reg);
uint32_t execute_set_le_xor_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
float execute_set_ls_or_f32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_ls_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_lt_and_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_and_u32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_lt_or_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_or_u32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
float execute_set_lt_xor_f32_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
uint32_t execute_set_lt_xor_u32_s16 (int16_t src1, int16_t src2, unsigned int pred_reg);
float execute_set_ne_and_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_b32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_or_f32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
float execute_set_ne_or_invert_f32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
int32_t execute_set_ne_or_s32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
float execute_set_ne_xor_f32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_b16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
uint32_t execute_set_ne_xor_u32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
int32_t execute_shr_s32 (int32_t src1, uint32_t src2);
uint64_t execute_subc_u64 (uint64_t src1, uint64_t src2, struct cc_register cc_reg);
int32_t execute_selp_s32 (int32_t src1, int32_t src2, unsigned int pred_src);
uint32_t execute_set_eq_xor_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_le_or_s32_s32 (int32_t src1, int32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_u32 (uint32_t src1, uint32_t src2, unsigned int pred_reg);
uint32_t execute_set_le_or_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
uint32_t execute_set_lo_xor_invert_u32_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);
int32_t execute_set_lt_and_s32_u16 (uint16_t src1, uint16_t src2, unsigned int pred_reg);
unsigned int execute_setp_gt_and_s64 (int64_t src1, int64_t src2, unsigned int pred_reg);
unsigned int execute_setp_lo_and_u64 (uint64_t src1, uint64_t src2, unsigned int pred_reg);